/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MowLibFluidUtils {
    public static LazyOptional<IFluidHandler> findFluidHandlerAtPos(Level world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.FLUID_HANDLER, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof ContainerEntity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static void dropLiquidsInWorld(Level level, BlockPos pos, IFluidHandler fluids) {
        FluidStack fluidStack = fluids.getFluidInTank(0).copy();
        Item item = fluidStack.getFluid().m_6859_();
        int x = -1;
        int z = -1;
        int y = 0;
        while (fluidStack.getAmount() >= 1000) {
            if (!(item instanceof BucketItem)) continue;
            BucketItem bucketItem = (BucketItem)item;
            BlockState state = level.m_8055_(pos.m_7918_(x, y, z));
            if (state.m_60734_().equals(Blocks.f_50016_) && bucketItem.m_142073_(null, level, pos.m_7918_(x, y, z), null)) {
                fluidStack.grow(-1000);
            }
            if (x >= 1 && z >= 1) {
                ++y;
                x = -1;
                z = -1;
            }
            if (x >= 1) {
                x = -1;
                ++z;
            }
            ++x;
        }
    }

    public static FluidStack getFluidStackFromItemStack(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            Fluid bucketFluid = bucket.getFluid();
            return new FluidStack(bucketFluid, 1000);
        }
        return FluidStack.EMPTY;
    }
}

