/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityWidget
extends AbstractWidget {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private Entity entity;
    private float rotation = 135.0f;
    private float rotationSpeed;
    private Vec3 defaultRotation;
    private Vec3 scale;
    private Vec3 offset;

    private EntityWidget(Builder builder) {
        super(builder.xPos, builder.yPos, builder.width, builder.height, Component.m_130674_((String)""));
        this.entity = builder.entity;
        this.rotationSpeed = builder.rotationSpeed;
        this.defaultRotation = builder.defaultRotation;
        this.scale = builder.scale;
        this.offset = builder.offset;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.rotationSpeed != 0.0f) {
            this.rotation += partialTicks * this.rotationSpeed;
        }
        EntityWidget.renderEntity(stack, this.entity, this.rotationSpeed != 0.0f ? new Vec3(this.defaultRotation.m_7096_(), (double)this.rotation, this.defaultRotation.m_7094_()) : this.defaultRotation, this.scale, this.offset, this.f_93620_, this.f_93621_);
    }

    public void m_142291_(NarrationElementOutput narration) {
        this.m_168802_(narration);
    }

    public static void renderEntity(PoseStack stack, Entity entity, Vec3 rotation, Vec3 scale, Vec3 offset, int xPos, int yPos) {
        stack.m_85836_();
        stack.m_85837_((double)xPos, (double)yPos, 1050.0);
        stack.m_85841_(1.0f, 1.0f, -1.0f);
        stack.m_85837_(0.0, 0.0, 1000.0);
        stack.m_85841_((float)scale.m_7096_(), (float)scale.m_7098_(), (float)scale.m_7094_());
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        stack.m_85845_(quaternion);
        stack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        stack.m_85845_(new Quaternion((float)(-rotation.m_7096_()), (float)(-rotation.m_7098_()), (float)(-rotation.m_7094_()), true));
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        EntityWidget.render(renderManager, entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        stack.m_85849_();
    }

    private static <E extends Entity> void render(EntityRenderDispatcher renderManager, E entity, double xPos, double yPos, double zPos, float rotation, float delta, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityRenderer entityRenderer = renderManager.m_114382_(entity);
        try {
            Vec3 renderOffset = entityRenderer.m_7860_(entity, delta);
            double finalX = xPos + renderOffset.m_7096_();
            double finalY = yPos + renderOffset.m_7098_();
            double finalZ = zPos + renderOffset.m_7094_();
            poseStack.m_85836_();
            poseStack.m_85837_(finalX, finalY, finalZ);
            entityRenderer.m_7392_(entity, rotation, delta, poseStack, buffer, packedLight);
            poseStack.m_85837_(-renderOffset.m_7096_(), -renderOffset.m_7098_(), -renderOffset.m_7094_());
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)exception, (String)"Rendering entity in world");
            CrashReportCategory entityCategory = crashReport.m_127514_("Entity being rendered");
            entity.m_7976_(entityCategory);
            CrashReportCategory detailsCategory = crashReport.m_127514_("Renderer details");
            detailsCategory.m_128159_("Assigned renderer", (Object)entityRenderer);
            detailsCategory.m_128159_("Location", (Object)CrashReportCategory.m_178937_((LevelHeightAccessor)Minecraft.m_91087_().f_91073_, (double)xPos, (double)yPos, (double)zPos));
            detailsCategory.m_128159_("Rotation", (Object)Float.valueOf(rotation));
            detailsCategory.m_128159_("Delta", (Object)Float.valueOf(delta));
            throw new ReportedException(crashReport);
        }
    }

    public static class Builder {
        private float rotationSpeed;
        private Vec3 scale = new Vec3(20.0, 20.0, 20.0);
        private Vec3 defaultRotation = new Vec3(15.0, 135.0, 0.0);
        private Vec3 offset = new Vec3(-1.25, -1.75, 0.0);
        private Entity entity;
        private int xPos;
        private int yPos;
        private int width;
        private int height;

        public Builder(Entity entity, int xPos, int yPos, int width, int height) {
            this.entity = entity;
            this.xPos = xPos;
            this.yPos = yPos;
            this.width = width;
            this.height = height;
        }

        public EntityWidget build() {
            return new EntityWidget(this);
        }

        public Builder defaultRotation(float x, float y, float z) {
            this.defaultRotation = new Vec3((double)x, (double)y, (double)z);
            return this;
        }

        public Builder offset(float x, float y, float z) {
            this.offset = new Vec3((double)(-x), (double)y, (double)z);
            return this;
        }

        public Builder rotationSpeed(float rotationSpeed) {
            this.rotationSpeed = rotationSpeed;
            return this;
        }

        public Builder scale(float x, float y, float z) {
            this.scale = new Vec3((double)x, (double)y, (double)z);
            return this;
        }
    }
}

