/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Capabilities.Dust;

import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class DustMagic {
    private int dustColor;
    private int dustAmount;
    public static final DustMagic EMPTY = new DustMagic(-1, 0);

    public DustMagic(int color, int amount) {
        this.dustColor = color;
        this.dustAmount = amount;
    }

    public boolean isEmpty() {
        return this.getDustColor() == -1;
    }

    public DustMagic copy() {
        return new DustMagic(this.dustColor, this.dustAmount);
    }

    public int getDustColor() {
        return this.dustColor;
    }

    public int getDustAmount() {
        return this.dustAmount;
    }

    public void setDustColor(int dustColor) {
        this.dustColor = dustColor;
    }

    public void setDustAmount(int dustAmount) {
        this.dustAmount = dustAmount;
    }

    public void grow(int amount) {
        this.setDustAmount(this.dustAmount + amount);
    }

    public void shrink(int amount) {
        this.setDustAmount(this.dustAmount - amount);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DustMagic)) {
            return false;
        }
        return this.isDustEqual((DustMagic)o);
    }

    public boolean isDustEqual(DustMagic magicIn) {
        return magicIn.getDustColor() == this.dustColor;
    }

    public boolean isDustEqualOrEmpty(DustMagic magicIn) {
        if (this.equals(new DustMagic(-1, 0)) || this.dustAmount <= 0) {
            return true;
        }
        if (this.dustAmount > 0) {
            return magicIn.getDustColor() == this.dustColor;
        }
        return false;
    }

    public static CompoundTag setDustMagicInTag(CompoundTag tag, DustMagic magicIn) {
        tag.m_128405_("mowlib_dustMagicColor", magicIn.getDustColor());
        tag.m_128405_("mowlib_dustMagicAmount", magicIn.getDustAmount());
        return tag;
    }

    public static ItemStack setDustMagicInStack(ItemStack stackToSet, DustMagic magicIn) {
        ItemStack copyStack = stackToSet.m_41777_();
        CompoundTag copyStackTag = stackToSet.m_41784_();
        copyStackTag.m_128405_("mowlib_dustMagicColor", magicIn.getDustColor());
        int dustAmount = magicIn.getDustAmount();
        if (stackToSet.m_41613_() > 1) {
            double maths = magicIn.getDustAmount() / stackToSet.m_41613_();
            dustAmount = (int)Math.floor(maths);
        }
        copyStackTag.m_128405_("mowlib_dustMagicAmount", dustAmount);
        copyStack.m_41751_(copyStackTag);
        return copyStack;
    }

    public static DustMagic getDustMagicInTag(CompoundTag tag) {
        DustMagic magic = new DustMagic(-1, 0);
        if (tag.m_128441_("mowlib_dustMagicColor")) {
            magic.setDustColor(tag.m_128451_("mowlib_dustMagicColor"));
            if (tag.m_128441_("mowlib_dustMagicAmount")) {
                magic.setDustAmount(tag.m_128451_("mowlib_dustMagicAmount"));
            }
        }
        return magic;
    }

    public static DustMagic getDustMagicInItemStack(ItemStack stack) {
        DustMagic magic = new DustMagic(-1, 0);
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_("mowlib_dustMagicColor")) {
                magic.setDustColor(tag.m_128451_("mowlib_dustMagicColor"));
                if (tag.m_128441_("mowlib_dustMagicAmount")) {
                    magic.setDustAmount(tag.m_128451_("mowlib_dustMagicAmount") * stack.m_41613_());
                }
            } else if (tag.m_128441_("mowlib_color")) {
                magic.setDustColor(MowLibColorReference.getColorFromItemStackInt(stack));
                magic.setDustAmount(stack.m_41613_());
            }
        }
        return magic;
    }
}

