/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.BaseDustStorageBlockItem;
import com.mowmaster.mowlib.Items.BaseDustStorageItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.mowlib.Recipes.MachineBlockRenderItemsRecipe;
import com.mowmaster.mowlib.Recipes.MachineBlockRepairItemsRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BaseBuiltMachineBlockEntity
extends MowLibBaseBlockEntity {
    private LazyOptional<IItemHandler> repairItemsHandler = LazyOptional.of(this::createRepairItemsHandler);
    private List<ItemStack> stacksList = new ArrayList<ItemStack>();
    private List<ItemStack> repairStackList = new ArrayList<ItemStack>();
    private List<String> repairTagList = new ArrayList<String>();
    private boolean isRepaired = false;
    public DustMagic dustMagic = new DustMagic(-1, 0);

    @Override
    public BlockPos getPos() {
        return this.f_58858_;
    }

    public BaseBuiltMachineBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public void update() {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        this.f_58857_.m_7260_(this.getPos(), state, state, 3);
        this.m_6596_();
    }

    public int getRepairSlotsForRepairs() {
        return 1;
    }

    private IItemHandler createRepairItemsHandler() {
        final int slots = this.getRepairSlotsForRepairs();
        return new ItemStackHandler(slots){

            protected void onLoad() {
                if (this.getSlots() < slots) {
                    for (int i = 0; i < this.getSlots(); ++i) {
                        BaseBuiltMachineBlockEntity.this.stacksList.add(i, this.getStackInSlot(i));
                    }
                    this.setSize(BaseBuiltMachineBlockEntity.this.getRepairListStacks().size());
                    for (int j = 0; j < BaseBuiltMachineBlockEntity.this.stacksList.size(); ++j) {
                        this.setStackInSlot(j, BaseBuiltMachineBlockEntity.this.stacksList.get(j));
                    }
                }
                super.onLoad();
            }

            protected void onContentsChanged(int slot) {
                if (BaseBuiltMachineBlockEntity.this.stacksList.size() <= 0) {
                    BaseBuiltMachineBlockEntity.this.update();
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot == BaseBuiltMachineBlockEntity.this.getAllowedSlot(stack) && BaseBuiltMachineBlockEntity.this.allowItemToBeInsert(stack);
            }
        };
    }

    public boolean isValidItem(ItemStack stack) {
        int slot;
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null && (slot = this.getAllowedSlot(stack)) != -1) {
            return rh.isItemValid(slot, stack);
        }
        return false;
    }

    public boolean isFullyRepaired() {
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (this.isRepaired) {
            return this.isRepaired;
        }
        if (rh != null) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                this.isRepaired = false;
                if (!rh.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            this.isRepaired = true;
            return true;
        }
        return this.isRepaired;
    }

    public List<ItemStack> getNextRepairItem() {
        if (!this.isRepaired) {
            List<ItemStack> allowedStacks = this.getRepairListStacks();
            List<String> allowedTags = this.getRepairListTags();
            IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
            if (rh != null) {
                for (int i = 0; i < rh.getSlots(); ++i) {
                    if (!rh.getStackInSlot(i).m_41619_()) continue;
                    ItemStack repairItemForSlot = allowedStacks.get(i);
                    if (repairItemForSlot.m_41720_().equals(Items.f_42127_)) {
                        ArrayList<ItemStack> stackie = new ArrayList<ItemStack>();
                        if (allowedTags.get(i).length() <= 0) continue;
                        String[] parts = allowedTags.get(i).split(":");
                        List GETTAGS = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(parts[0], parts[1]))).stream().toList();
                        for (Item item : GETTAGS) {
                            stackie.add(new ItemStack((ItemLike)item));
                        }
                        return stackie;
                    }
                    return Arrays.asList(repairItemForSlot);
                }
            }
        }
        return null;
    }

    public boolean addRepairItem(Player player, ItemStack repairItemFromBlock, boolean simulate) {
        int slot;
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        ItemStack insertedItem = repairItemFromBlock.m_41777_();
        insertedItem.m_41764_(1);
        if (rh != null && rh.isItemValid(slot = this.getAllowedSlot(insertedItem), insertedItem) && slot < rh.getSlots()) {
            if (!simulate) {
                rh.insertItem(slot, insertedItem, false);
                if (insertedItem.m_41720_() instanceof BaseDustStorageItem || insertedItem.m_41720_() instanceof BaseDustStorageBlockItem) {
                    this.dustMagic = DustMagic.getDustMagicInItemStack(insertedItem);
                }
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getListOfInsertedItemsToDisplay() {
        ArrayList<ItemStack> stacksList = new ArrayList<ItemStack>();
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                if (!this.getRenderAllowed(rh.getStackInSlot(i))) continue;
                stacksList.add(rh.getStackInSlot(i));
            }
        }
        return stacksList;
    }

    public ItemStack getStoredRepairItemStack(int slot) {
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null) {
            return rh.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> getListofRepairs(Level level, ItemStack stackIn) {
        if (!level.m_5776_()) {
            if (stackIn.m_41619_()) {
                return new ArrayList<ItemStack>();
            }
            Container cont = MowLibContainerUtils.getContainer(2);
            cont.m_6836_(-1, stackIn);
            List recipes = level.m_7465_().m_44056_((RecipeType)MachineBlockRepairItemsRecipe.Type.INSTANCE, cont, level);
            ArrayList<ItemStack> stackie = new ArrayList<ItemStack>();
            for (MachineBlockRepairItemsRecipe recipe : recipes) {
                if (recipe.m_8043_().m_41619_()) continue;
                stackie.add(recipe.m_8043_());
            }
            return recipes.size() > 0 ? stackie : new ArrayList<ItemStack>();
        }
        return new ArrayList<ItemStack>();
    }

    public List<String> getListofRepairTags(Level level, ItemStack stackIn) {
        if (stackIn.m_41619_()) {
            return new ArrayList<String>();
        }
        Container cont = MowLibContainerUtils.getContainer(2);
        cont.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)MachineBlockRepairItemsRecipe.Type.INSTANCE, cont, level);
        ArrayList<String> stackie = new ArrayList<String>();
        for (MachineBlockRepairItemsRecipe recipe : recipes) {
            if (recipe.m_8043_().m_41619_()) continue;
            stackie.add(recipe.getResultTag());
        }
        return recipes.size() > 0 ? stackie : new ArrayList<String>();
    }

    public List<ItemStack> getRepairListStacks() {
        if (this.repairStackList.size() == 0) {
            return this.getListofRepairs(this.m_58904_(), new ItemStack((ItemLike)this.getBlockForThisBlockEntity()));
        }
        return this.repairStackList;
    }

    public List<String> getRepairListTags() {
        if (this.repairTagList.size() == 0) {
            return this.getListofRepairTags(this.m_58904_(), new ItemStack((ItemLike)this.getBlockForThisBlockEntity()));
        }
        return this.repairTagList;
    }

    public boolean isStackAllowed(ItemStack stack) {
        List<ItemStack> allowedStacks = this.getRepairListStacks();
        List<String> allowedTags = this.getRepairListTags();
        if (allowedStacks.size() > 0) {
            for (int i = 0; i < allowedStacks.size(); ++i) {
                if (allowedStacks.get(i).m_41720_().equals(stack.m_41720_())) {
                    return true;
                }
                if (!allowedStacks.get(i).m_41720_().equals(Items.f_42127_) || i >= allowedTags.size() || allowedTags.get(i).length() <= 0) continue;
                String[] parts = allowedTags.get(i).split(":");
                List GETTAGS = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(parts[0], parts[1]))).stream().toList();
                if (!GETTAGS.contains(stack.m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowItemToBeInsert(ItemStack stack) {
        List<ItemStack> allowedStacks = this.getRepairListStacks();
        List<String> allowedTags = this.getRepairListTags();
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null && this.isStackAllowed(stack)) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                if (i >= allowedStacks.size()) continue;
                if (allowedStacks.get(i).m_41720_().equals(stack.m_41720_()) && rh.getStackInSlot(i).m_41619_()) {
                    return true;
                }
                if (!allowedStacks.get(i).m_41720_().equals(Items.f_42127_) || !rh.getStackInSlot(i).m_41619_()) continue;
                String[] parts = allowedTags.get(i).split(":");
                List GETTAGS = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(parts[0], parts[1]))).stream().toList();
                if (!GETTAGS.contains(stack.m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    public int getAllowedSlot(ItemStack stack) {
        List<ItemStack> allowedStacks = this.getRepairListStacks();
        List<String> allowedTags = this.getRepairListTags();
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null && this.isStackAllowed(stack)) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                if (i >= allowedStacks.size()) continue;
                if (allowedStacks.get(i).m_41720_().equals(stack.m_41720_())) {
                    return i;
                }
                if (!allowedStacks.get(i).m_41720_().equals(Items.f_42127_) || allowedTags.get(i).length() <= 0) continue;
                String[] parts = allowedTags.get(i).split(":");
                List GETTAGS = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(parts[0], parts[1]))).stream().toList();
                if (!GETTAGS.contains(stack.m_41720_())) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean hasDustContainer() {
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                Item item = rh.getStackInSlot(i).m_41720_();
                if (!(item instanceof BaseDustStorageItem) && !(item instanceof BaseDustStorageBlockItem)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Integer> getDustContainerSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        IItemHandler rh = (IItemHandler)this.repairItemsHandler.orElse(null);
        if (rh != null) {
            for (int i = 0; i < rh.getSlots(); ++i) {
                Item item = rh.getStackInSlot(i).m_41720_();
                if (!(item instanceof BaseDustStorageItem) && !(item instanceof BaseDustStorageBlockItem)) continue;
                list.add(i);
            }
        }
        return list;
    }

    public void syncDustInTableWithContainer() {
        int slot;
        ItemStack getDustContainerStack;
        if (this.hasDustContainer() && ((getDustContainerStack = this.getStoredRepairItemStack(slot = this.getDustContainerSlots().get(0).intValue())).m_41720_() instanceof BaseDustStorageItem || getDustContainerStack.m_41720_() instanceof BaseDustStorageBlockItem)) {
            DustMagic.setDustMagicInStack(getDustContainerStack, this.dustMagic);
        }
    }

    @Nullable
    protected MachineBlockRenderItemsRecipe getRenderRecipe(List<ItemStack> stackIn) {
        Container cont = MowLibContainerUtils.getContainer(2);
        for (int i = 0; i < stackIn.size(); ++i) {
            if (!cont.m_7013_(i, stackIn.get(i))) continue;
            cont.m_6836_(-1, stackIn.get(i));
        }
        List recipes = this.m_58904_().m_7465_().m_44056_((RecipeType)MachineBlockRenderItemsRecipe.Type.INSTANCE, cont, this.m_58904_());
        return this.m_58904_() != null ? (recipes.size() > 0 ? (MachineBlockRenderItemsRecipe)recipes.get(0) : null) : null;
    }

    protected List<Float> getProcessResultRenderList(MachineBlockRenderItemsRecipe recipe) {
        return recipe == null ? new ArrayList() : recipe.getResultList();
    }

    protected boolean getProcessResultRender(MachineBlockRenderItemsRecipe recipe) {
        return recipe == null ? false : recipe.getResultRenderItem();
    }

    protected boolean getProcessResultRenderAsBlock(MachineBlockRenderItemsRecipe recipe) {
        return recipe == null ? false : recipe.getResultRenderAsBlock();
    }

    protected Collection<ItemStack> getProcessResultRenderItem(MachineBlockRenderItemsRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    public Block getBlockForThisBlockEntity() {
        return Blocks.f_50016_;
    }

    public List<Float> getRenderParams(ItemStack repairItem) {
        List<ItemStack> stackList = Arrays.asList(new ItemStack((ItemLike)this.getBlockForThisBlockEntity()), repairItem);
        MachineBlockRenderItemsRecipe recipe = this.getRenderRecipe(stackList);
        if (recipe != null) {
            return this.getProcessResultRenderList(recipe);
        }
        return new ArrayList<Float>();
    }

    public boolean getRenderAllowed(ItemStack repairItem) {
        List<ItemStack> stackList = Arrays.asList(new ItemStack((ItemLike)this.getBlockForThisBlockEntity()), repairItem);
        MachineBlockRenderItemsRecipe recipe = this.getRenderRecipe(stackList);
        if (recipe != null) {
            return this.getProcessResultRender(recipe);
        }
        return false;
    }

    public boolean getRenderAsBlock(ItemStack repairItem) {
        List<ItemStack> stackList = Arrays.asList(new ItemStack((ItemLike)this.getBlockForThisBlockEntity()), repairItem);
        MachineBlockRenderItemsRecipe recipe = this.getRenderRecipe(stackList);
        if (recipe != null) {
            return this.getProcessResultRenderAsBlock(recipe);
        }
        return false;
    }

    public ItemStack getRenderItem(ItemStack repairItem) {
        List<ItemStack> stackList = Arrays.asList(new ItemStack((ItemLike)this.getBlockForThisBlockEntity()), repairItem);
        MachineBlockRenderItemsRecipe recipe = this.getRenderRecipe(stackList);
        Collection<ItemStack> jsonResults = this.getProcessResultRenderItem(recipe);
        if (!jsonResults.iterator().next().m_41619_()) {
            ItemStack returner = jsonResults.iterator().next();
            if (returner.m_41720_().equals(Items.f_42127_)) {
                return repairItem;
            }
            return returner;
        }
        return repairItem;
    }

    public void dropInventoryItems(Level worldIn, BlockPos pos) {
        IItemHandler h = (IItemHandler)this.repairItemsHandler.orElse(null);
        this.syncDustInTableWithContainer();
        for (int i = 0; i < h.getSlots(); ++i) {
            MowLibItemUtils.spawnItemStack(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), h.getStackInSlot(i));
        }
    }

    public double getRepairParticleHeight() {
        return 1.0;
    }

    public void tick() {
        if (this.m_58904_().m_46467_() % 20L == 0L && !this.isFullyRepaired()) {
            MowLibPacketHandler.sendToNearby(this.f_58857_, this.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)this.getPos().m_123341_() + 0.5, (double)this.getPos().m_123342_() + this.getRepairParticleHeight(), (double)this.getPos().m_123343_() + 0.5, 255, 255, 255));
        }
    }

    @Override
    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        CompoundTag invPrivateTag = p_155245_.m_128469_("inv_repairs");
        this.repairItemsHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invPrivateTag));
        if (p_155245_.m_128441_("inv_repairsList")) {
            ArrayList<ItemStack> repairList = new ArrayList<ItemStack>();
            CompoundTag invTag = p_155245_.m_128469_("inv_repairsList");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                repairList.add(handler.getStackInSlot(i));
            }
            this.repairStackList = repairList;
        }
        this.isRepaired = p_155245_.m_128471_("isRepaired");
        this.dustMagic = DustMagic.getDustMagicInTag(p_155245_);
    }

    @Override
    protected void m_183515_(CompoundTag p_187471_) {
        super.m_183515_(p_187471_);
        this.save(p_187471_);
    }

    @Override
    public CompoundTag save(CompoundTag p_58888_) {
        this.repairItemsHandler.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            p_58888_.m_128365_("inv_repairs", (Tag)compound);
        });
        List<ItemStack> listed = this.getRepairListStacks();
        if (listed.size() > 0) {
            CompoundTag compoundStorage = new CompoundTag();
            ItemStackHandler handler = new ItemStackHandler();
            handler.setSize(listed.size());
            for (int i = 0; i < handler.getSlots(); ++i) {
                handler.setStackInSlot(i, listed.get(i));
            }
            compoundStorage = handler.serializeNBT();
            p_58888_.m_128365_("inv_repairsList", (Tag)compoundStorage);
        }
        p_58888_.m_128379_("isRepaired", this.isRepaired);
        return DustMagic.setDustMagicInTag(p_58888_, this.dustMagic);
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        this.handleUpdateTag(pkt.m_131708_());
        this.f_58857_.m_7260_(this.getPos(), state, state, 3);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.repairItemsHandler != null) {
            this.repairItemsHandler.invalidate();
        }
    }
}

