/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.EditableClientItemExtensions;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class BaseItem
extends Item {
    private final ItemProperties properties;

    public BaseItem(Item.Properties properties) {
        super(properties);
        this.properties = null;
    }

    public BaseItem(ItemProperties properties) {
        super(properties.toUnderlying());
        this.properties = properties;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
    }

    public ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        return ItemUseResult.fromUnderlying((InteractionResultHolder<ItemStack>)super.m_7203_(level, player, hand));
    }

    public InteractionFeedback interactWithBlockFirst(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithEntity(ItemStack stack, LivingEntity target, Player player, InteractionHand hand) {
        return InteractionFeedback.PASS;
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> information, TooltipFlag flag) {
        this.appendItemInformation(stack, (BlockGetter)level, information::add, flag.m_7050_());
        super.m_7373_(stack, level, information, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.interact(player.m_21120_(hand), player, hand, level).toUnderlying(level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return this.interactWithEntity((ItemStack)stack, (LivingEntity)target, (Player)player, (InteractionHand)hand).interactionResult;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.interactWithBlock((ItemStack)context.m_43722_(), (Player)context.m_43723_(), (InteractionHand)context.m_43724_(), (Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_(), (Vec3)context.m_43720_()).interactionResult;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.interactWithBlockFirst((ItemStack)stack, (Player)context.m_43723_(), (InteractionHand)context.m_43724_(), (Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_(), (Vec3)context.m_43720_()).interactionResult;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        this.inventoryUpdate(stack, level, entity, slot, isSelected);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new EditableClientItemExtensions());
    }

    protected String m_41467_() {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(this);
        return identifier.m_135827_() + ".item." + identifier.m_135815_();
    }

    public boolean isInCreativeGroup(CreativeModeTab tab) {
        return this.properties != null && this.properties.groups.contains(tab);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.properties != null ? this.properties.groups : super.getCreativeTabs();
    }

    protected static class ItemUseResult {
        private final InteractionResult result;
        private final ItemStack resultingStack;

        public static ItemUseResult pass(ItemStack stack) {
            return new ItemUseResult(InteractionResult.SUCCESS, stack);
        }

        public static ItemUseResult consume(ItemStack stack) {
            return new ItemUseResult(InteractionResult.CONSUME, stack);
        }

        public static ItemUseResult success(ItemStack stack) {
            return new ItemUseResult(InteractionResult.SUCCESS, stack);
        }

        public static ItemUseResult fail(ItemStack stack) {
            return new ItemUseResult(InteractionResult.FAIL, stack);
        }

        @Deprecated
        public static ItemUseResult fromUnderlying(InteractionResultHolder<ItemStack> underlying) {
            return new ItemUseResult(underlying.m_19089_(), (ItemStack)underlying.m_19095_());
        }

        private ItemUseResult(InteractionResult result, ItemStack resultingStack) {
            this.result = result;
            this.resultingStack = resultingStack;
        }

        @Deprecated
        public InteractionResultHolder<ItemStack> toUnderlying(boolean isClientSide) {
            return new InteractionResultHolder(this.result == InteractionResult.SUCCESS ? (isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME) : this.result, (Object)this.resultingStack);
        }
    }

    public static enum InteractionFeedback {
        PASS(InteractionResult.PASS),
        CONSUME(InteractionResult.CONSUME),
        SUCCESS(InteractionResult.SUCCESS);

        private final InteractionResult interactionResult;

        private InteractionFeedback(InteractionResult interactionResult) {
            this.interactionResult = interactionResult;
        }

        @Deprecated
        public InteractionResult getUnderlying() {
            return this.interactionResult;
        }
    }
}

