/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.util.InventoryUtil;
import net.minecraft.world.item.ItemStack;

public class TurtleTransferToCommand
implements TurtleCommand {
    private final int slot;
    private final int quantity;

    public TurtleTransferToCommand(int slot, int limit) {
        this.slot = slot;
        this.quantity = limit;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().m_7407_(turtle.getSelectedSlot(), this.quantity);
        if (stack.m_41619_()) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        ItemStack remainder = InventoryUtil.storeItemsIntoSlot(turtle.getInventory(), stack, this.slot);
        if (!remainder.m_41619_()) {
            InventoryUtil.storeItemsIntoSlot(turtle.getInventory(), remainder, turtle.getSelectedSlot());
        }
        if (remainder != stack) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

