/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import java.io.IOException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class TreasureDiskMedia
implements IMedia {
    public static final IMedia INSTANCE = new TreasureDiskMedia();

    private TreasureDiskMedia() {
    }

    @Override
    public String getLabel(ItemStack stack) {
        return TreasureDiskItem.getTitle(stack);
    }

    @Override
    public @Nullable Mount createDataMount(ItemStack stack, ServerLevel level) {
        Mount rootTreasure = ComputerCraftAPI.createResourceMount(level.m_7654_(), "computercraft", "lua/treasure");
        if (rootTreasure == null) {
            return null;
        }
        String subPath = TreasureDiskItem.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

