/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.screen.OwlCourierSendScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundOpenOwlCourierSendScreenPacket {
    int owlId;
    InteractionHand hand;
    int selected;

    public ClientboundOpenOwlCourierSendScreenPacket(int owlId, InteractionHand hand, int selected) {
        this.owlId = owlId;
        this.hand = hand;
        this.selected = selected;
    }

    public static void encode(ClientboundOpenOwlCourierSendScreenPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.owlId);
        buffer.writeBoolean(object.hand == InteractionHand.MAIN_HAND);
        buffer.writeInt(object.selected);
    }

    public static ClientboundOpenOwlCourierSendScreenPacket decode(FriendlyByteBuf buffer) {
        return new ClientboundOpenOwlCourierSendScreenPacket(buffer.readInt(), buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, buffer.readInt());
    }

    public static void consume(ClientboundOpenOwlCourierSendScreenPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            Entity patt2015$temp = world.m_6815_(packet.owlId);
            if (patt2015$temp instanceof OwlEntity) {
                OwlEntity owl = (OwlEntity)patt2015$temp;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientboundOpenOwlCourierSendScreenPacket.setScreen(owl, packet.hand, packet.selected));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setScreen(OwlEntity owl, InteractionHand hand, int selected) {
        Minecraft.m_91087_().m_91152_((Screen)new OwlCourierSendScreen(owl, hand, selected));
    }
}

