/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class CauldronParticleData
extends ParticleType<CauldronParticleData>
implements ParticleOptions {
    ParticleType<CauldronParticleData> type;
    FluidStack fluid;
    public static final ParticleOptions.Deserializer<CauldronParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CauldronParticleData>(){

        public CauldronParticleData fromCommand(ParticleType<CauldronParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new CauldronParticleData(particleTypeIn, new FluidStack((Fluid)Fluids.f_76193_, 1));
        }

        public CauldronParticleData fromNetwork(ParticleType<CauldronParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new CauldronParticleData(particleTypeIn, buffer.readFluidStack());
        }
    };

    public CauldronParticleData(ParticleType<?> type, FluidStack fluid) {
        super(true, DESERIALIZER);
        this.type = type;
        this.fluid = fluid;
    }

    @Nonnull
    public ParticleType<CauldronParticleData> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFluidStack(this.fluid);
    }

    public String m_5942_() {
        return HexereiUtil.getKeyOrThrow(this.type) + " " + HexereiUtil.getKeyOrThrow(this.fluid.getFluid());
    }

    public static Codec<CauldronParticleData> codec(ParticleType<CauldronParticleData> particleType) {
        return RecordCodecBuilder.create(c -> c.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)c, color -> new CauldronParticleData(particleType, (FluidStack)color)));
    }

    public Codec<CauldronParticleData> m_7652_() {
        return CauldronParticleData.codec(this);
    }
}

