/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CofferItem;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class Coffer
extends BaseEntityBlock
implements ITileEntity<CofferTile>,
SimpleWaterloggedBlock,
DyeableLeatherItem {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = Optional.of(Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0)).get();
    public static final VoxelShape SHAPE_TURNED = Optional.of(Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0)).get();

    public static int getColorValue(BlockState state, BlockPos pos, BlockGetter level) {
        ItemStack clone = ((Coffer)state.m_60734_()).m_7397_(level, pos, state);
        int dyeCol = Coffer.getColorStatic(clone);
        DyeColor color = Coffer.getDyeColorNamed(clone);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorValue(DyeColor color, ItemStack stack) {
        int dyeCol = Coffer.getColorStatic(stack);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 4337438;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public static DyeColor getDyeColorNamed(ItemStack stack) {
        return HexereiUtil.getDyeColorNamed(stack.m_41786_().getString(), 0);
    }

    public void m_213897_(BlockState p_60462_, ServerLevel p_60463_, BlockPos p_60464_, RandomSource p_60465_) {
        Coffer.m_49902_((BlockState)p_60462_, (BlockState)p_60462_, (LevelAccessor)p_60463_, (BlockPos)p_60464_, (int)0);
        super.m_213897_(p_60462_, p_60463_, p_60464_, p_60465_);
    }

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST || p_220053_1_.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
            return SHAPE_TURNED;
        }
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.COFFER_TILE.get() ? (world2, pos, state2, entity) -> ((CofferTile)entity).tick() : null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_150930_((Item)ModItems.CROW_FLUTE.get()) && itemstack.m_41784_().m_128451_("commandMode") == 2) {
            player.m_21120_(handIn).m_41661_(new UseOnContext(player, handIn, hit));
            return InteractionResult.SUCCESS;
        }
        if (!worldIn.m_5776_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof CofferTile) {
                MenuProvider containerProvider = this.createContainerProvider(worldIn, pos);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.writeBoolean(true).writeLong(tileEntity.m_58899_().m_121878_()));
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Coffer(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, WATERLOGGED});
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            world.m_46961_(pos, false);
            if (world.m_8055_(pos) != state && !world.m_5776_()) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_41852_) {
                    player.m_21008_(InteractionHand.MAIN_HAND, cloneItemStack);
                } else {
                    player.m_150109_().m_150079_(cloneItemStack);
                }
            }
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.m_7397_((BlockGetter)world, pos, state);
            if (world.m_8055_(pos) != state && !world.m_5776_()) {
                world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), cloneItemStack));
            }
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<CofferTile> tileEntityOptional = Optional.ofNullable((CofferTile)this.getBlockEntity(worldIn, pos));
        CompoundTag tag = item.m_41784_();
        CompoundTag inv = tileEntityOptional.map(coffer -> coffer.itemStackHandler.serializeNBT()).orElse(new CompoundTag());
        ItemStackHandler empty = tileEntityOptional.map(herb_jar -> herb_jar.itemStackHandler).orElse(new ItemStackHandler(36));
        boolean flag = false;
        for (int i = 0; i < 36; ++i) {
            if (empty.getStackInSlot(i).m_41619_()) continue;
            flag = true;
            break;
        }
        if (flag) {
            tag.m_128365_("Inventory", (Tag)inv);
        }
        this.m_41115_(item, tileEntityOptional.map(cofferTile -> cofferTile.dyeColor).orElse(4337438));
        tag.m_128405_("ButtonToggled", tileEntityOptional.map(cofferTile -> cofferTile.buttonToggled).orElse(0).intValue());
        Component customName = tileEntityOptional.map(CofferTile::m_7770_).orElse(null);
        if (customName != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            te.readInventory(stack.m_41784_().m_128469_("Inventory"));
            te.setDyeColor(Coffer.getColorStatic(stack));
            te.buttonToggled = stack.m_41784_().m_128451_("ButtonToggled");
            te.sync();
        });
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) != null) {
            ((CofferTile)tileentity).customName = stack.m_41786_();
        }
    }

    public boolean isEmpty(ItemStackHandler handler) {
        boolean empty = true;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            Item item = stack.m_41720_();
            if (item instanceof CofferItem) {
                CofferItem cofferItem = (CofferItem)item;
                ItemStackHandler handler = cofferItem.createHandler();
                handler.deserializeNBT(stack.m_41784_().m_128469_("Inventory"));
                if (this.isEmpty(handler)) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.coffer_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.coffer_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.coffer_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.dyeable").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.coffer").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, world, pos, rand);
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new CofferContainer(i, worldIn, pos, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                if (((CofferTile)worldIn.m_7702_((BlockPos)pos)).customName != null) {
                    return Component.m_237115_((String)((CofferTile)worldIn.m_7702_((BlockPos)pos)).customName.getString());
                }
                return Component.m_237115_((String)"screen.hexerei.coffer");
            }
        };
    }

    @Override
    public Class<CofferTile> getTileEntityClass() {
        return CofferTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CofferTile((BlockEntityType)ModTileEntities.COFFER_TILE.get(), pos, state);
    }
}

