/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.platform.Window;
import dev.obscuria.lootjournal.LootJournal;
import java.util.function.BiFunction;
import java.util.function.Function;

public enum Anchor {
    TOP_LEFT(window -> 0, (window, offset) -> offset, separation -> 12 + separation, false),
    TOP_RIGHT(Window::m_85445_, (window, offset) -> offset, separation -> 12 + separation, true),
    BOTTOM_LEFT(window -> 0, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, false),
    BOTTOM_RIGHT(Window::m_85445_, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, true);

    private final Function<Window, Integer> originXFunc;
    private final BiFunction<Window, Integer, Integer> originYFunc;
    private final Function<Integer, Integer> stepFunc;
    private final boolean reversed;

    private Anchor(Function<Window, Integer> originXFunc, BiFunction<Window, Integer, Integer> originYFunc, Function<Integer, Integer> stepFunc, boolean reversed) {
        this.originXFunc = originXFunc;
        this.originYFunc = originYFunc;
        this.stepFunc = stepFunc;
        this.reversed = reversed;
    }

    public int originX(Window window) {
        return this.originXFunc.apply(window);
    }

    public int originY(Window window) {
        return this.originYFunc.apply(window, LootJournal.CONFIG.anchorOffset);
    }

    public int step() {
        return this.stepFunc.apply(LootJournal.CONFIG.notificationSeparation);
    }

    public boolean isReversed() {
        return this.reversed;
    }
}

