/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.mixin.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import portb.biggerstacks.config.ClientConfig;

@Mixin(value={GuiGraphics.class})
public abstract class ItemRendererMixin {
    private static final DecimalFormat BILLION_FORMAT = new DecimalFormat("#.##B");
    private static final DecimalFormat MILLION_FORMAT = new DecimalFormat("#.##M");
    private static final DecimalFormat THOUSAND_FORMAT = new DecimalFormat("#.##K");

    private static String getStringForBigStackCount(int count) {
        if (((Boolean)ClientConfig.enableNumberShortening.get()).booleanValue()) {
            BigDecimal decimal = new BigDecimal(count).round(new MathContext(3));
            double value = decimal.doubleValue();
            if (value >= 1.0E9) {
                return BILLION_FORMAT.format(value / 1.0E9);
            }
            if (value >= 1000000.0) {
                return MILLION_FORMAT.format(value / 1000000.0);
            }
            if (value > 1000.0) {
                return THOUSAND_FORMAT.format(value / 1000.0);
            }
        }
        return String.valueOf(count);
    }

    private static double calculateStringScale(Font font, String countString) {
        int width = font.m_92895_(countString);
        if (width < 16) {
            return 1.0;
        }
        return 16.0 / (double)width;
    }

    @Redirect(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"))
    private void doNothing1(PoseStack instance, float p_254202_, float p_253782_, float p_254238_) {
    }

    @Redirect(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I"))
    private int doNothing2(GuiGraphics instance, Font p_283343_, String p_281896_, int p_283569_, int p_283418_, int p_281560_, boolean p_282130_) {
        return 0;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I")})
    private void renderText(Font font, ItemStack itemStack, int x, int y, String alternateCount, CallbackInfo ci) {
        PoseStack poseStack = ((GuiGraphics)this).m_280168_();
        String text = alternateCount == null ? ItemRendererMixin.getStringForBigStackCount(itemStack.m_41613_()) : alternateCount;
        float scale = (float)ItemRendererMixin.calculateStringScale(font, text);
        float inverseScale = 1.0f / scale;
        float xTransform = (float)(x + 16) * inverseScale - (float)font.m_92895_(text);
        float f = (float)(y + 16) * inverseScale;
        Objects.requireNonNull(font);
        float yTransform = f - 9.0f;
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_(xTransform, yTransform, 200.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_271703_(text, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_252880_(-xTransform, -yTransform, 0.0f);
        bufferSource.m_109911_();
    }
}

