/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.customterrain;

import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.util.GeneratorHeightGetter;
import net.potionstudios.biomeswevegone.util.MathUtil;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.util.BlendUtil;
import org.joml.Vector2d;
import org.joml.Vector4d;

public class BasaltBarreraExtension {
    public static void runBasaltBarreraExtension(ChunkAccess chunk, WorldGenRegion region, ChunkGenerator generator) {
        ChunkPos pos = chunk.m_7697_();
        ImprovedNoise hexRadiusNoise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(region.m_7328_()));
        ImprovedNoise hexHeightNoise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(region.m_7328_() + 2394504L));
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.m_151382_(x);
                int worldZ = pos.m_151391_(z);
                int landHeight = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, worldX, worldZ) / 10 * 10;
                if (chunk.m_141937_() >= landHeight) continue;
                mutable.m_122178_(worldX, landHeight, worldZ);
                Holder currentBiome = region.m_204166_((BlockPos)mutable);
                if (!currentBiome.m_203565_(BWGBiomes.BASALT_BARRERA)) continue;
                double hexRadiusNoiseFreq = 0.01;
                double hexDelta = (hexRadiusNoise.m_164308_((double)mutable.m_123341_() * hexRadiusNoiseFreq, 0.0, (double)mutable.m_123343_() * hexRadiusNoiseFreq) + 1.0) * 0.5;
                int hexRadius = (int)BlendingFunction.EaseInOutCirc.INSTANCE.apply(hexDelta, 4.0, 10.0);
                Vector4d vector4d = MathUtil.calcHexInfo(new Vector2d((double)mutable.m_123341_(), (double)mutable.m_123343_()), hexRadius);
                Vector2d hexCenter = new Vector2d((double)mutable.m_123341_() - vector4d.x, (double)mutable.m_123343_() - vector4d.y);
                mutable.m_122169_(hexCenter.x, (double)mutable.m_123342_(), hexCenter.y);
                Holder hexCenterBiome = region.m_204166_((BlockPos)mutable);
                if (!hexCenterBiome.m_203565_(BWGBiomes.BASALT_BARRERA)) continue;
                double biomeBlend = BlendUtil.blendBiomeEdge((Holder<Biome>)currentBiome, arg_0 -> ((WorldGenRegion)region).m_204166_(arg_0), (BlockPos)mutable, hexRadius * 2, 1);
                ChunkAccess hexCenterChunk = region.m_46865_((BlockPos)mutable);
                if (!(hexCenterChunk instanceof GeneratorHeightGetter)) continue;
                GeneratorHeightGetter generatorHeightGetter = (GeneratorHeightGetter)hexCenterChunk;
                Random random = new Random(mutable.m_121878_() + region.m_7328_());
                BlockState state = random.nextBoolean() ? Blocks.f_50137_.m_49966_() : Blocks.f_152597_.m_49966_();
                int hexHeightOceanFloorHeight = generatorHeightGetter.getHeight(generator, Heightmap.Types.OCEAN_FLOOR_WG, mutable.m_123341_(), mutable.m_123343_(), region.m_6018_().m_7726_().m_214994_(), true);
                double noiseFreq = 0.1;
                mutable.m_122178_(worldX, hexHeightOceanFloorHeight, worldZ);
                double heightDelta = (hexHeightNoise.m_164308_(hexCenter.x * noiseFreq, 0.0, hexCenter.y * noiseFreq) + 1.0) * 0.5;
                double addedHeight = BlendingFunction.EaseInOutCirc.INSTANCE.apply(heightDelta, 1.0, 4.0);
                double topY = (double)hexHeightOceanFloorHeight + addedHeight;
                double blendedY = Mth.m_14085_((double)landHeight, (double)topY, (double)biomeBlend);
                int worldY = landHeight - 5;
                while ((double)worldY <= blendedY) {
                    mutable.m_122178_(worldX, worldY, worldZ);
                    chunk.m_6978_((BlockPos)mutable, state, false);
                    ++worldY;
                }
            }
        }
    }
}

