/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.set;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class BWGBlockSet {
    private static final ArrayList<BWGBlockSet> blockSets = new ArrayList();
    private final Supplier<Block> base;
    private final Supplier<SlabBlock> slab;
    private final Supplier<StairBlock> stairs;
    private final Supplier<WallBlock> wall;

    public BWGBlockSet(String name, BlockBehaviour.Properties properties) {
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(name + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(name + "_stairs", () -> new StairBlock(this.base.get().m_49966_(), properties));
        this.wall = BWGBlocks.registerBlockItem(name + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(String name, String alt, BlockBehaviour.Properties properties) {
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(alt + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(alt + "_stairs", () -> new StairBlock(this.base.get().m_49966_(), properties));
        this.wall = BWGBlocks.registerBlockItem(alt + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(Supplier<Block> base, Supplier<SlabBlock> slab, Supplier<StairBlock> stairs, Supplier<WallBlock> wall) {
        this.base = base;
        this.slab = slab;
        this.stairs = stairs;
        this.wall = wall;
        blockSets.add(this);
    }

    public BWGBlockSet(String name, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(color);
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(name + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(name + "_stairs", () -> new StairBlock(this.base.get().m_49966_(), properties));
        this.wall = BWGBlocks.registerBlockItem(name + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public BWGBlockSet(String name, String alt, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(color);
        this.base = BWGBlocks.registerBasicBlockWithItem(name, properties);
        this.slab = BWGBlocks.registerBlockItem(alt + "_slab", () -> new SlabBlock(properties));
        this.stairs = BWGBlocks.registerBlockItem(alt + "_stairs", () -> new StairBlock(this.base.get().m_49966_(), properties));
        this.wall = BWGBlocks.registerBlockItem(alt + "_wall", () -> new WallBlock(properties));
        blockSets.add(this);
    }

    public Block getBase() {
        return this.base.get();
    }

    public SlabBlock getSlab() {
        return this.slab.get();
    }

    public StairBlock getStairs() {
        return this.stairs.get();
    }

    public WallBlock getWall() {
        return this.wall.get();
    }

    public BlockFamily getBlockFamily() {
        return BlockFamilies.m_175935_((Block)this.getBase()).m_175986_((Block)this.getSlab()).m_175988_((Block)this.getStairs()).m_175996_((Block)this.getWall()).m_175962_();
    }

    public static ArrayList<BWGBlockSet> getBlockSets() {
        return blockSets;
    }
}

