/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.server.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExceptionlessFunctions {
    public static <E extends Throwable> Runnable uncheckedRunnable(ThrowingRunnable<E> t) throws E {
        return () -> {
            try {
                t.accept();
            }
            catch (Throwable exception) {
                ExceptionlessFunctions.throwActualException(exception);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> uncheckedConsumer(ThrowingConsumer<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable exception) {
                ExceptionlessFunctions.throwActualException(exception);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> uncheckedSupplier(ThrowingSupplier<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable exception) {
                return ExceptionlessFunctions.throwActualException(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> uncheckedFunction(ThrowingFunction<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable exception) {
                return ExceptionlessFunctions.throwActualException(exception);
            }
        };
    }

    private static <E extends Exception, T> T throwActualException(Throwable exception) throws E {
        throw (Exception)exception;
    }

    public static interface ThrowingRunnable<E extends Throwable> {
        public void accept() throws E;
    }

    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface ThrowingSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }
}

