/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style.effect;

import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.effect.TooltipEffect;
import com.obscuria.tooltips.client.style.particle.SparkleParticle;
import com.obscuria.tooltips.client.style.particle.TooltipParticle;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec2;

public class TailsEffect
implements TooltipEffect {
    private final List<TooltipParticle> particles = new ArrayList<TooltipParticle>();
    private float lastParticle = 0.0f;

    @Override
    public void render(TooltipContext context, Vec2 pos, Point size) {
        float time = context.time() * 0.5f;
        size = new Point(size.x + 6, size.y + 6);
        Vec2 start = pos.m_165908_(-3.0f);
        Vec2 tail1 = this.calculateTail(start, size, time, 0.0f);
        Vec2 tail2 = this.calculateTail(start, size, time, 0.5f);
        if (time - this.lastParticle >= 0.02f) {
            this.lastParticle = time;
            float rotation = (float)(Math.random() * (Math.PI * 2));
            float radius = 2.0f;
            this.particles.add(new SparkleParticle(-1, -40705, 1.0f, tail1, new Vec2(tail1.f_82470_ + (float)Math.cos(rotation) * 2.0f, tail1.f_82471_ + (float)Math.sin(rotation) * 2.0f)));
            this.particles.add(new SparkleParticle(-1, -40705, 1.0f, tail2, new Vec2(tail2.f_82470_ + (float)Math.cos(rotation) * 2.0f, tail2.f_82471_ + (float)Math.sin(rotation) * 2.0f)));
        }
        context.renderParticles(this.particles);
    }

    @Override
    public void reset() {
        this.lastParticle = 0.0f;
        this.particles.clear();
    }

    private Vec2 calculateTail(Vec2 pos, Point size, float seconds, float offset) {
        float verticalMod = (float)size.y / 1.0f / (float)size.x;
        float timelapse = (seconds + offset * (2.0f + verticalMod * 2.0f)) % (2.0f + verticalMod * 2.0f);
        return timelapse < 1.0f ? new Vec2(pos.f_82470_ + (float)size.x * timelapse, pos.f_82471_) : (timelapse < 1.0f + verticalMod ? new Vec2(pos.f_82470_ + (float)size.x, pos.f_82471_ + (float)size.y * ((timelapse - 1.0f) / verticalMod)) : (timelapse < 2.0f + verticalMod ? new Vec2(pos.f_82470_ + (float)size.x - (float)size.x * (timelapse - (1.0f + verticalMod)), pos.f_82471_ + (float)size.y) : new Vec2(pos.f_82470_, pos.f_82471_ + (float)size.y - (float)size.y * ((timelapse - (2.0f + verticalMod)) / verticalMod))));
    }

    @Override
    public boolean canStackWith(TooltipEffect other) {
        return !(other instanceof TailsEffect);
    }
}

