/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.obscuria.tooltips.ObscureTooltips;
import com.obscuria.tooltips.client.renderer.TooltipRenderer;
import com.obscuria.tooltips.client.style.StyleFilter;
import com.obscuria.tooltips.client.style.TooltipStylePreset;
import com.obscuria.tooltips.client.style.effect.TooltipEffect;
import com.obscuria.tooltips.client.style.frame.TooltipFrame;
import com.obscuria.tooltips.client.style.icon.TooltipIcon;
import com.obscuria.tooltips.client.style.panel.TooltipPanel;
import com.obscuria.tooltips.registry.TooltipsRegistry;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import oshi.util.tuples.Pair;

public final class ResourceLoader
implements ResourceManagerReloadListener {
    public static Marker LOADER = MarkerManager.getMarker((String)"LOADER");
    public static final ResourceLoader INSTANCE = new ResourceLoader();
    private static final HashMap<ResourceLocation, TooltipPanel> PANELS = new HashMap();
    private static final HashMap<ResourceLocation, TooltipFrame> FRAMES = new HashMap();
    private static final HashMap<ResourceLocation, TooltipIcon> ICONS = new HashMap();
    private static final HashMap<ResourceLocation, TooltipEffect> EFFECTS = new HashMap();
    private static final List<ResourceLocation> PRESETS_KEYS = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> STYLES_KEYS = new ArrayList<ResourceLocation>();
    private static final HashMap<ResourceLocation, Pair<StyleFilter, TooltipStylePreset>> PRESETS = new HashMap();
    private static final HashMap<ResourceLocation, Pair<StyleFilter, TooltipStylePreset>> STYLES = new HashMap();

    private ResourceLoader() {
    }

    public static Optional<TooltipStylePreset> getStyleFor(ItemStack stack) {
        TooltipStylePreset.Builder builder = new TooltipStylePreset.Builder();
        for (ResourceLocation key : STYLES_KEYS) {
            Pair<StyleFilter, TooltipStylePreset> style = STYLES.get(key);
            if (!((StyleFilter)style.getA()).test(stack)) continue;
            ((TooltipStylePreset)style.getB()).getPanel().ifPresent(builder::withPanel);
            ((TooltipStylePreset)style.getB()).getFrame().ifPresent(builder::withFrame);
            ((TooltipStylePreset)style.getB()).getIcon().ifPresent(builder::withIcon);
            builder.withEffects((List<TooltipEffect>)((TooltipStylePreset)style.getB()).getEffects());
            break;
        }
        for (ResourceLocation key : PRESETS_KEYS) {
            Pair<StyleFilter, TooltipStylePreset> preset = PRESETS.get(key);
            if (!((StyleFilter)preset.getA()).test(stack)) continue;
            ((TooltipStylePreset)preset.getB()).getPanel().ifPresent(panel -> builder.withPanel((TooltipPanel)panel, false));
            ((TooltipStylePreset)preset.getB()).getFrame().ifPresent(frame -> builder.withFrame((TooltipFrame)frame, false));
            ((TooltipStylePreset)preset.getB()).getIcon().ifPresent(icon -> builder.withIcon((TooltipIcon)icon, false));
            builder.withEffects((List<TooltipEffect>)((TooltipStylePreset)preset.getB()).getEffects());
        }
        return builder.isEmpty() ? Optional.empty() : Optional.of(builder.build());
    }

    public void m_6213_(ResourceManager manager) {
        TooltipRenderer.clear();
        this.clear();
        manager.m_7536_().forEach(pack -> {
            for (String namespace : pack.m_5698_(PackType.CLIENT_RESOURCES)) {
                this.loadElements((PackResources)pack, namespace, "tooltips/panels", (HashMap)PANELS, TooltipsRegistry::buildPanel);
                this.loadElements((PackResources)pack, namespace, "tooltips/frames", (HashMap)FRAMES, TooltipsRegistry::buildFrame);
                this.loadElements((PackResources)pack, namespace, "tooltips/icons", (HashMap)ICONS, TooltipsRegistry::buildIcon);
                this.loadElements((PackResources)pack, namespace, "tooltips/effects", (HashMap)EFFECTS, TooltipsRegistry::buildEffect);
                this.loadPresets((PackResources)pack, namespace);
                this.loadStyles((PackResources)pack, namespace);
            }
        });
        this.sort();
        ObscureTooltips.LOGGER.debug(LOADER, "Loaded {} Elements, {} Presets and {} Styles", (Object)(PANELS.size() + FRAMES.size() + ICONS.size() + EFFECTS.size()), (Object)PRESETS.size(), (Object)STYLES.size());
    }

    private void clear() {
        PANELS.clear();
        FRAMES.clear();
        ICONS.clear();
        EFFECTS.clear();
        PRESETS_KEYS.clear();
        PRESETS.clear();
        STYLES_KEYS.clear();
        STYLES.clear();
    }

    private void sort() {
        List<ResourceLocation> presets = PRESETS_KEYS.stream().sorted(Comparator.comparingInt(key -> ((StyleFilter)ResourceLoader.PRESETS.get((Object)key).getA()).priority)).toList();
        PRESETS_KEYS.clear();
        PRESETS_KEYS.addAll(Lists.reverse(presets));
        List<ResourceLocation> styles = STYLES_KEYS.stream().sorted(Comparator.comparingInt(key -> ((StyleFilter)ResourceLoader.STYLES.get((Object)key).getA()).priority)).toList();
        STYLES_KEYS.clear();
        STYLES_KEYS.addAll(Lists.reverse(styles));
    }

    private <T> void loadElements(PackResources pack, String namespace, String path, HashMap<ResourceLocation, T> registry, BiFunction<ResourceLocation, JsonObject, Optional<T>> builder) {
        pack.m_8031_(PackType.CLIENT_RESOURCES, namespace, path, (location, resource) -> {
            if (location.m_135815_().endsWith(".json")) {
                try {
                    ResourceLocation key = new ResourceLocation(location.toString().replace(path + "/", "").replace(".json", ""));
                    ((Optional)builder.apply(key, JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader((InputStream)resource.m_247737_(), StandardCharsets.UTF_8))).getAsJsonObject())).ifPresent(element -> registry.put(key, element));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void loadPresets(PackResources pack, String namespace) {
        pack.m_8031_(PackType.CLIENT_RESOURCES, namespace, "tooltips/presets", (location, resource) -> {
            if (location.m_135815_().endsWith(".json")) {
                try {
                    ResourceLocation key = new ResourceLocation(location.toString().replace("tooltips/presets/", "").replace(".json", ""));
                    JsonObject root = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader((InputStream)resource.m_247737_(), StandardCharsets.UTF_8))).getAsJsonObject();
                    TooltipStylePreset style = this.serializeStyle(root);
                    StyleFilter predicate = StyleFilter.fromJson(root.getAsJsonObject("filter"));
                    if (root.has("priority")) {
                        predicate.priority = root.get("priority").getAsInt();
                    }
                    PRESETS_KEYS.add(key);
                    PRESETS.put(key, (Pair<StyleFilter, TooltipStylePreset>)new Pair((Object)predicate, (Object)style));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void loadStyles(PackResources pack, String namespace) {
        pack.m_8031_(PackType.CLIENT_RESOURCES, namespace, "tooltips/styles", (location, resource) -> {
            if (location.m_135815_().endsWith(".json")) {
                try {
                    ResourceLocation key = new ResourceLocation(location.toString().replace("tooltips/styles/", "").replace(".json", ""));
                    JsonObject root = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader((InputStream)resource.m_247737_(), StandardCharsets.UTF_8))).getAsJsonObject();
                    TooltipStylePreset style = this.serializeStyle(root);
                    StyleFilter predicate = StyleFilter.fromJson(root.getAsJsonObject("filter"));
                    if (root.has("priority")) {
                        predicate.priority = root.get("priority").getAsInt();
                    }
                    STYLES_KEYS.add(key);
                    STYLES.put(key, (Pair<StyleFilter, TooltipStylePreset>)new Pair((Object)predicate, (Object)style));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private TooltipStylePreset serializeStyle(JsonObject root) {
        return new TooltipStylePreset.Builder().withPanel(root.has("panel") ? PANELS.get(new ResourceLocation(root.get("panel").getAsString())) : null).withFrame(root.has("frame") ? FRAMES.get(new ResourceLocation(root.get("frame").getAsString())) : null).withIcon(root.has("icon") ? ICONS.get(new ResourceLocation(root.get("icon").getAsString())) : null).withEffects(root.has("effects") ? root.getAsJsonArray("effects").asList().stream().map(effect -> EFFECTS.getOrDefault(new ResourceLocation(effect.getAsString()), (a, b, c) -> {})).toList() : null).build();
    }
}

