/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.ConfigLoadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModWorldGen {
    private static final ResourceLocation waystone = new ResourceLocation("waystones", "waystone");
    private static final ResourceLocation mossyWaystone = new ResourceLocation("waystones", "mossy_waystone");
    private static final ResourceLocation sandyWaystone = new ResourceLocation("waystones", "sandy_waystone");
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    public static DeferredObject<PlacementModifierType<WaystonePlacement>> waystonePlacement;

    public static void initialize(BalmWorldGen worldGen) {
        worldGen.registerFeature(waystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.waystone.m_49966_()));
        worldGen.registerFeature(mossyWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.mossyWaystone.m_49966_()));
        worldGen.registerFeature(sandyWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.sandyWaystone.m_49966_()));
        waystonePlacement = worldGen.registerPlacementModifier(ModWorldGen.id("waystone"), () -> () -> WaystonePlacement.CODEC);
        ResourceLocation waystonesCommonConfig = new ResourceLocation("waystones", "common");
        Runnable configLoadHandler = () -> {
            TagKey IS_DESERT = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("waystones", "is_desert"));
            TagKey IS_SWAMP = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("waystones", "is_swamp"));
            TagKey IS_MUSHROOM = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("waystones", "is_mushroom"));
            worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_DESERT), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
            worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)BiomeTags.f_207610_), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
            worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_SWAMP), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
            worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_MUSHROOM), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
            worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherTag(List.of(IS_SWAMP, IS_DESERT, BiomeTags.f_207610_, IS_MUSHROOM)), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        };
        Balm.getEvents().onEvent(ConfigLoadedEvent.class, event -> {
            if (event.getSchema().identifier().equals((Object)waystonesCommonConfig)) {
                configLoadHandler.run();
            }
        });
        if (Balm.getConfig().getActiveConfig(new ResourceLocation("waystones", "common")) != null) {
            configLoadHandler.run();
        }
        Balm.getEvents().onEvent(ServerStartingEvent.class, event -> ModWorldGen.setupDynamicRegistries((RegistryAccess)event.getServer().m_206579_()));
    }

    private static BiomePredicate matchesTag(TagKey<Biome> tag) {
        return (resourceLocation, biome) -> biome.m_203656_(tag);
    }

    private static BiomePredicate matchesNeitherTag(List<TagKey<Biome>> tags) {
        return (resourceLocation, biome) -> {
            for (TagKey tag : tags) {
                if (!biome.m_203656_(tag)) continue;
                return false;
            }
            return true;
        };
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }

    private static ResourceLocation getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGen.worldGenStyle;
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> mossyWaystone;
            case WorldGenStyle.SANDY -> sandyWaystone;
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield sandyWaystone;
                    }
                    case MOSSY: {
                        yield mossyWaystone;
                    }
                }
                yield waystone;
            }
            default -> waystone;
        };
    }

    public static void setupDynamicRegistries(RegistryAccess registryAccess) {
        if (WaystonesConfig.getActive().worldGen.spawnInVillages || WaystonesConfig.getActive().worldGen.forceSpawnInVillages) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(RegistryAccess registryAccess, String villagePiece, ResourceLocation waystoneStructure, int weight) {
        StructureTemplatePool pool;
        Holder.Reference emptyProcessorList = registryAccess.m_175515_(Registries.f_257011_).m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        LegacySinglePoolElement piece = (LegacySinglePoolElement)StructurePoolElement.m_210512_((String)waystoneStructure.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        if (piece instanceof WaystoneStructurePoolElement) {
            WaystoneStructurePoolElement element = (WaystoneStructurePoolElement)piece;
            element.waystones$setIsWaystone(true);
        }
        if ((pool = (StructureTemplatePool)registryAccess.m_175515_(Registries.f_256948_).m_6612_(new ResourceLocation(villagePiece)).orElse(null)) != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<StructurePoolElement>)listOfPieces);
            ArrayList<Pair<StructurePoolElement, Integer>> listOfWeightedPieces = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

