/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeEntityBaseAttributeMessage(UUID uuid, ResourceLocation attribute, Double value) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_entity_base_attribute");

    public static ChangeEntityBaseAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeEntityBaseAttributeMessage(buffer.m_130259_(), buffer.m_130281_(), buffer.readDouble());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130085_(this.attribute);
        buffer.writeDouble(this.value.doubleValue());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.attribute == null) {
            log.error("Invalid base attribute for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.value == null) {
            log.error("Invalid value for base attribute {} for {} from {}", (Object)this.attribute, easyNPC, (Object)serverPlayer);
            return;
        }
        if (!AttributeHandler.setBaseAttribute(easyNPC, this.attribute, this.value)) {
            log.error("Unable to set base attribute {} for {} from {}", (Object)this.attribute, easyNPC, (Object)serverPlayer);
        }
    }
}

