/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ScaleData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final float DEFAULT_SCALE_X = 1.0f;
    public static final float DEFAULT_SCALE_Y = 1.0f;
    public static final float DEFAULT_SCALE_Z = 1.0f;
    public static final String EASY_NPC_DATA_SCALE_DATA_TAG = "ScaleData";

    public static void registerSyncedScaleData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Scale Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SCALE_X, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135029_));
        map.put(SynchedDataIndex.SCALE_Y, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135029_));
        map.put(SynchedDataIndex.SCALE_Z, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135029_));
    }

    default public Float getDefaultScaleX() {
        return Float.valueOf(1.0f);
    }

    default public Float getDefaultScaleY() {
        return Float.valueOf(1.0f);
    }

    default public Float getDefaultScaleZ() {
        return Float.valueOf(1.0f);
    }

    default public void setModelScaleAxis(ModelScaleAxis scaleAxis, Float scaleValue) {
        switch (scaleAxis) {
            case X: {
                this.setScaleX(scaleValue);
                break;
            }
            case Y: {
                this.setScaleY(scaleValue);
                break;
            }
            case Z: {
                this.setScaleZ(scaleValue);
                break;
            }
            default: {
                log.error("Invalid scale axis {} for {}", (Object)scaleAxis, (Object)this);
            }
        }
    }

    default public Float getScaleX() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_X);
    }

    default public void setScaleX(Float scale) {
        if (!Objects.equals(this.getScaleX(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_X, scale);
            this.getEntity().m_6210_();
        }
    }

    default public Float getScaleY() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_Y);
    }

    default public void setScaleY(Float scale) {
        if (!Objects.equals(this.getScaleY(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_Y, scale);
            this.getEntity().m_6210_();
        }
    }

    default public Float getScaleZ() {
        return (Float)this.getSynchedEntityData(SynchedDataIndex.SCALE_Z);
    }

    default public void setScaleZ(Float scale) {
        if (!Objects.equals(this.getScaleZ(), scale)) {
            this.setSynchedEntityData(SynchedDataIndex.SCALE_Z, scale);
            this.getEntity().m_6210_();
        }
    }

    default public void defineSynchedScaleData() {
        this.defineSynchedEntityData(SynchedDataIndex.SCALE_X, this.getDefaultScaleX());
        this.defineSynchedEntityData(SynchedDataIndex.SCALE_Y, this.getDefaultScaleY());
        this.defineSynchedEntityData(SynchedDataIndex.SCALE_Z, this.getDefaultScaleZ());
    }

    default public void addAdditionalScaleData(CompoundTag compoundTag) {
        if (Objects.equals(this.getScaleX(), this.getDefaultScaleX()) && Objects.equals(this.getScaleY(), this.getDefaultScaleY()) && Objects.equals(this.getScaleZ(), this.getDefaultScaleZ())) {
            return;
        }
        compoundTag.m_128365_(EASY_NPC_DATA_SCALE_DATA_TAG, (Tag)CompoundTagUtils.writeScale(this.getScaleX().floatValue(), this.getScaleY().floatValue(), this.getScaleZ().floatValue()));
    }

    default public void readAdditionalScaleData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(EASY_NPC_DATA_SCALE_DATA_TAG)) {
            return;
        }
        CustomScale customScale = CompoundTagUtils.readCustomScale(compoundTag.m_128469_(EASY_NPC_DATA_SCALE_DATA_TAG));
        if (customScale.x() > 0.0f) {
            this.setScaleX(Float.valueOf(customScale.x()));
        }
        if (customScale.y() > 0.0f) {
            this.setScaleY(Float.valueOf(customScale.y()));
        }
        if (customScale.z() > 0.0f) {
            this.setScaleZ(Float.valueOf(customScale.z()));
        }
    }
}

