/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration;

import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class ConfigurationScreen<T extends EasyNPCMenu>
extends Screen<T> {
    protected Button homeButton = null;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;
    protected int numberOfDescriptionTextLines = 1;
    protected List<FormattedCharSequence> descriptionTextComponents = Collections.emptyList();

    public ConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component, 328, 243);
        this.showCloseButton = false;
    }

    protected void renderDescriptionText(GuiGraphics guiGraphics, int descriptionLeft, int descriptionTop) {
        if (!this.descriptionTextComponents.isEmpty() && this.numberOfDescriptionTextLines > 0) {
            for (int line = 0; line < this.numberOfDescriptionTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.descriptionTextComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, descriptionLeft, descriptionTop + line * (9 + 2));
            }
        }
    }

    protected void setDescriptionText(String textId) {
        this.setDescriptionText((Component)TextComponent.getTranslatedConfigText(textId));
    }

    protected void setDescriptionText(Component component) {
        this.descriptionTextComponents = this.f_96547_.m_92923_((FormattedText)component, this.imageWidth - 20);
        this.numberOfDescriptionTextLines = this.descriptionTextComponents.size();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.buttonLeftPos = this.leftPos + 13;
        this.buttonTopPos = this.topPos + 3;
        this.contentLeftPos = this.leftPos + 7;
        this.contentTopPos = this.topPos + 23;
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 3, this.buttonTopPos, 10, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN)));
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        if (!this.compactMode) {
            Text.drawString(guiGraphics, this.f_96547_, this.f_96539_, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040);
        }
    }

    public void showMainScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
    }

    @Override
    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 && ConfigurationScreen.m_96639_()) {
            this.showMainScreen();
            return true;
        }
        return super.m_7933_(keyCode, unused1, unused2);
    }
}

