/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.EasyNPCClient;
import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.commands.ModArgumentTypes;
import de.markusbordihn.easynpc.compat.CompatHandler;
import de.markusbordihn.easynpc.compat.CompatManager;
import de.markusbordihn.easynpc.config.Config;
import de.markusbordihn.easynpc.debug.DebugManager;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.item.ModItems;
import de.markusbordihn.easynpc.menu.MenuHandler;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="easy_npc")
public class EasyNPC {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public EasyNPC() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        log.info("Initializing {} (Forge) ...", (Object)"Easy NPC");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
        if (version.isPresent() && "MOD_DEV".equals(version.get())) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Constants.GAME_DIR = FMLPaths.GAMEDIR.get();
        Constants.CONFIG_DIR = FMLPaths.CONFIGDIR.get();
        log.info("{} Configuration ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Config.register(FMLEnvironment.dist == Dist.DEDICATED_SERVER);
        log.info("{} Common Data Files ...", (Object)"\ud83d\udde3 Register Easy NPC");
        DataFileHandler.registerCommonDataFiles();
        log.info("{} Entity Data Serializers ...", (Object)"\ud83d\udde3 Register Easy NPC");
        EntityDataSerializersManager.register();
        log.info("{} Compatibility Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        CompatManager.registerCompatHandler(new CompatHandler());
        log.info("{} Command Argument Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModArgumentTypes.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        log.info("{} Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModEntityType.ENTITY_TYPES.register(modEventBus);
        log.info("{} Blocks ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.BLOCKS.register(modEventBus);
        log.info("{} Blocks Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModBlocks.BLOCK_ENTITY_TYPES.register(modEventBus);
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModItems.ITEMS.register(modEventBus);
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC");
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        MenuManager.registerMenuHandler(new MenuHandler());
        modEventBus.addListener(MenuHandler::registerMenuHandler);
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC");
        modEventBus.addListener(event -> event.enqueueWork(() -> {
            NetworkHandlerManager.registerHandler(new NetworkHandler());
            NetworkHandlerManager.registerNetworkMessages(NetworkHandlerManagerType.BOTH);
        }));
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> new EasyNPCClient(modEventBus));
    }
}

