/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;

public enum PlayerFactionProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        CompoundTag tag;
        if (entityAccessor.getServerData().m_128425_("playerFaction", 10) && (tag = entityAccessor.getServerData().m_128469_("playerFaction")).m_128441_("faction")) {
            String factionId = tag.m_128461_("faction");
            int level = tag.m_128451_("level");
            IPlayableFaction faction = (IPlayableFaction)VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(factionId));
            MutableComponent component = Component.m_237115_((String)faction.getName().getString()).m_130946_(": ");
            if (tag.m_128441_("lordTitle")) {
                int lordLevel = tag.m_128451_("lordLevel");
                if (IWailaConfig.get().getPlugin().get(JadePlugin.PLAYER_FACTION_LORD_LEVEL_NUMBER)) {
                    component.m_7220_((Component)Component.m_237115_((String)"text.vampirism.lord").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"text.vampirism.level"))).m_130946_(" ").m_130946_(String.valueOf(lordLevel));
                } else {
                    ExtraCodecs.f_252442_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("lordTitle")).result().map(Pair::getFirst).ifPresent(arg_0 -> ((MutableComponent)component).m_7220_(arg_0));
                }
            } else {
                component.m_7220_((Component)Component.m_237115_((String)"text.vampirism.level")).m_130946_(" ").m_130946_(String.valueOf(level));
            }
            iTooltip.add((Component)component.m_130938_(style -> style.m_131148_(faction.getChatColor())));
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.PLAYER_FACTION;
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FactionPlayerHandler.getOpt((Player)player).ifPresent(handler -> handler.getCurrentFactionPlayer().ifPresent(fp -> {
                CompoundTag tag = new CompoundTag();
                IFaction currentFaction = fp.getDisguisedAs();
                if (currentFaction != null) {
                    tag.m_128359_("faction", currentFaction.getID().toString());
                    tag.m_128405_("level", handler.getCurrentLevel());
                    if (handler.getLordLevel() > 0) {
                        tag.m_128405_("lordLevel", handler.getLordLevel());
                        DataResult tagDataResult = ExtraCodecs.f_252442_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)handler.getLordTitle());
                        tagDataResult.result().ifPresent(t -> {
                            tag.m_128405_("lordLevel", handler.getLordLevel());
                            tag.m_128365_("lordTitle", t);
                        });
                    }
                }
                compoundTag.m_128365_("playerFaction", (Tag)tag);
            }));
        }
    }
}

