/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.ability;

import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.ability.AbilityPeriod;
import com.eeeab.eeeabsmobs.sever.ability.AbilityType;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;

public abstract class Ability<T extends LivingEntity> {
    private final AbilityPeriod[] abilityPeriods;
    private final AbilityCapability.IAbilityCapability abilityCapability;
    private final AbilityType<T, ? extends Ability<?>> abilityType;
    private final int maxCoolingTick;
    private int sectionTick;
    private int sectionIndex;
    private int coolingTimer;
    private boolean inUse;
    private final T user;
    private int tick;

    public Ability(AbilityType<T, ? extends Ability<?>> abilityType, T user, AbilityPeriod[] abilityPeriods, int maxCoolingTick) {
        this.abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)user);
        this.abilityType = abilityType;
        this.user = user;
        this.abilityPeriods = abilityPeriods;
        this.maxCoolingTick = maxCoolingTick;
    }

    public void start() {
        this.abilityCapability.setAbility(this);
        this.tick = 0;
        this.sectionTick = 0;
        this.sectionIndex = 0;
        this.inUse = true;
    }

    public void tick() {
        if (this.isUsing()) {
            this.tickUsing();
            ++this.tick;
            ++this.sectionTick;
            AbilityPeriod section = this.getSection();
            if (section instanceof AbilityPeriod.AbilityPeriodInstant) {
                this.nextPeriod();
            } else if (section instanceof AbilityPeriod.AbilityPeriodDuration) {
                AbilityPeriod.AbilityPeriodDuration period = (AbilityPeriod.AbilityPeriodDuration)section;
                if (this.sectionTick >= period.duration) {
                    this.nextPeriod();
                }
            }
        } else if (this.coolingTimer > 0) {
            --this.coolingTimer;
        }
    }

    protected void tickUsing() {
    }

    public void end() {
        this.coolingTimer = this.getMaxCoolingTick();
        this.inUse = false;
        this.tick = 0;
        this.sectionTick = 0;
        this.sectionIndex = 0;
        this.abilityCapability.setAbility(null);
    }

    public AbilityType<T, ? extends Ability<?>> getAbilityType() {
        return this.abilityType;
    }

    public int getTick() {
        return this.tick;
    }

    public T getUser() {
        return this.user;
    }

    public boolean isUsing() {
        return this.inUse;
    }

    public boolean isCooling() {
        return this.coolingTimer > 0;
    }

    public boolean canUse() {
        return !this.isUsing() && !this.isCooling() && this.abilityCapability.getAbility() == null;
    }

    private int getMaxCoolingTick() {
        return this.maxCoolingTick;
    }

    private void nextPeriod() {
        this.jumpPeriod(this.sectionIndex + 1);
    }

    private void jumpPeriod(int index) {
        this.sectionIndex = index;
        this.sectionTick = 0;
        if (this.sectionIndex >= this.abilityPeriods.length) {
            this.end();
        }
    }

    public AbilityPeriod getSection() {
        if (this.sectionIndex >= this.abilityPeriods.length) {
            return null;
        }
        return this.abilityPeriods[this.sectionIndex];
    }

    public CompoundTag writeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.isUsing()) {
            compoundTag.m_128405_("tick", this.tick);
            compoundTag.m_128405_("section_index", this.sectionIndex);
            compoundTag.m_128405_("section_tick", this.sectionTick);
        } else if (this.coolingTimer > 0) {
            compoundTag.m_128405_("cooling_tick", this.coolingTimer);
        }
        return compoundTag;
    }

    public void readNBT(Tag nbt) {
        CompoundTag compoundTag = (CompoundTag)nbt;
        boolean inUse = compoundTag.m_128441_("tick");
        if (inUse) {
            this.tick = compoundTag.m_128451_("tick");
            this.sectionIndex = compoundTag.m_128451_("section_index");
            this.sectionTick = compoundTag.m_128451_("section_tick");
        } else {
            this.coolingTimer = compoundTag.m_128451_("cooling_tick");
        }
    }
}

