/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.effects.RenderAbsBeam;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityGuardianLaser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderGuardianLaser
extends RenderAbsBeam<EntityGuardianLaser> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/guardian_laser.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float GUARDIAN_START_RADIUS = 1.09f;
    private static final float PLAYER_START_RADIUS = 0.8f;
    private static final float GUARDIAN_BEAM_RADIUS = 0.9f;
    private static final float PLAYER_BEAM_RADIUS = 0.6f;
    private boolean playerView;
    private boolean isPlayer;

    public RenderGuardianLaser(EntityRendererProvider.Context mgr) {
        super(mgr, 1.09f, 0.9f);
    }

    @Override
    public ResourceLocation getTextureLocation(EntityGuardianLaser entity) {
        return TEXTURE;
    }

    @Override
    public void render(EntityGuardianLaser laser, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.playerView = laser.caster instanceof Player && Minecraft.m_91087_().f_91074_ == laser.caster && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        this.isPlayer = laser.isPlayer() || laser.caster instanceof Player;
        super.render(laser, entityYaw, delta, matrixStackIn, bufferIn, packedLightIn);
    }

    @Override
    protected void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean inGround) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = !this.isPlayer ? 1.09f + (inGround ? 0.2f : 0.0f) : 0.8f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, -SIZE, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, SIZE, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, SIZE, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, -SIZE, 0.0f, maxU, minV, packedLightIn);
    }

    @Override
    protected void renderStart(EntityGuardianLaser laser, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        if (this.playerView) {
            return;
        }
        super.renderStart(laser, frame, matrixStackIn, builder, delta, packedLightIn);
    }

    @Override
    protected void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        float offset = this.playerView ? -1.0f : 0.0f;
        float SIZE = this.isPlayer ? 0.6f : 0.9f;
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, offset, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, length, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, length, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, offset, 0.0f, maxU, minV, packedLightIn);
    }
}

