/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class NetworkTools {
    public static void writeSChPMap(FriendlyByteBuf buf, Map<String, Set<ChunkPos>> map) {
        buf.writeInt(map.size());
        map.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.writeInt(value.size());
            value.forEach(x -> buf.writeLong(x.m_45588_()));
        });
    }

    public static Map<String, Set<ChunkPos>> readSChPMap(FriendlyByteBuf buf) {
        HashMap<String, Set<ChunkPos>> map = new HashMap<String, Set<ChunkPos>>();
        int mapsize = buf.readInt();
        for (int i = 0; i < mapsize; ++i) {
            String key = buf.m_130277_();
            int listsize = buf.readInt();
            HashSet<ChunkPos> list = new HashSet<ChunkPos>();
            for (int j = 0; j < listsize; ++j) {
                list.add(new ChunkPos(buf.readLong()));
            }
            map.put(key, list);
        }
        return map;
    }

    public static void writeWorldKey(ResourceKey<Level> worldKey, FriendlyByteBuf buf) {
        ResourceLocation loc = worldKey.m_135782_();
        buf.m_130085_(loc);
    }

    public static ResourceKey<Level> readWorldKey(FriendlyByteBuf buf) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
    }

    public static void writeWorldPos(WorldPos pos, FriendlyByteBuf buf) {
        buf.m_130064_(pos.pos);
        NetworkTools.writeWorldKey(pos.type, buf);
        buf.m_130077_(pos.id);
    }

    public static WorldPos readWorldPos(FriendlyByteBuf buf) {
        return new WorldPos(buf.m_130135_(), NetworkTools.readWorldKey(buf), buf.m_130259_());
    }

    public static void writeRLWPMap(Map<ResourceLocation, List<WorldPos>> map, FriendlyByteBuf buf) {
        buf.writeInt(map.size());
        map.forEach((x, y) -> {
            buf.m_130085_(x);
            buf.writeInt(y.size());
            y.forEach(e -> NetworkTools.writeWorldPos(e, buf));
        });
    }

    public static Map<ResourceLocation, List<WorldPos>> readRLWPMap(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, List<WorldPos>> map = new HashMap<ResourceLocation, List<WorldPos>>();
        int mapsize = buf.readInt();
        for (int i = 0; i < mapsize; ++i) {
            ResourceLocation loc = buf.m_130281_();
            int listsize = buf.readInt();
            ArrayList<WorldPos> list = new ArrayList<WorldPos>();
            for (int j = 0; j < listsize; ++j) {
                list.add(NetworkTools.readWorldPos(buf));
            }
            map.put(loc, list);
        }
        return map;
    }

    public static boolean returnOnNull(Object ... objects) {
        return Arrays.stream(objects).anyMatch(Objects::isNull);
    }
}

