/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class RegenerationAOFEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public RegenerationAOFEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void deactivate(T entity) {
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaRegenerationCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaRegenerationDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        double healthPercent = entity.m_21223_() / entity.m_21233_();
        if (healthPercent < 0.1) {
            return 3;
        }
        if (healthPercent < 0.4) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onUpdate(@NotNull T entity, int duration) {
        List entities = entity.m_20193_().m_45976_(Mob.class, new AABB(entity.m_20185_() - 4.0, entity.m_20186_() - 1.0, entity.m_20189_() - 4.0, entity.m_20185_() + 4.0, entity.m_20186_() + 3.0, entity.m_20189_() + 4.0));
        for (Mob e : entities) {
            if (VampirismAPI.factionRegistry().getFaction((Entity)entity) != VampirismAPI.factionRegistry().getFaction((Entity)e)) continue;
            e.m_5634_(entity.m_21233_() / 100.0f * (float)((Integer)VampirismConfig.BALANCE.eaRegenerationAmount.get()).intValue() / ((float)this.getDuration(((IAdjustableLevel)entity).getEntityLevel()) * 20.0f));
            if (duration % 20 != 0) continue;
            ModParticles.spawnParticlesServer(entity.m_20193_(), (ParticleOptions)ParticleTypes.f_123750_, e.m_20185_(), e.m_20186_() + 0.2, e.m_20189_(), 3, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

