/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerBodyOverlayLayer<T extends MinionEntity<?>, M extends VisibilityPlayerModel<T>>
extends RenderLayer<T, M> {
    public PlayerBodyOverlayLayer(@NotNull DualBipedRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.m_117347_((Entity)entitylivingbaseIn);
        RenderType type = ((VisibilityPlayerModel)this.m_117386_()).getRenderType((PlayerModel)this.m_117386_(), texture, entitylivingbaseIn);
        if (((MinionEntity)entitylivingbaseIn).shouldRenderLordSkin()) {
            if (type != null) {
                ((VisibilityPlayerModel)this.m_117386_()).setVisibility(VisibilityPlayerModel.Visibility.HEAD);
                ((VisibilityPlayerModel)this.m_117386_()).m_7695_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            texture = ((MinionEntity)entitylivingbaseIn).getOverlayPlayerProperties().map(Pair::getLeft).orElse(texture);
            RenderType bodyType = ((VisibilityPlayerModel)this.m_117386_()).getRenderType((PlayerModel)this.m_117386_(), texture, entitylivingbaseIn);
            if (bodyType != null) {
                ((VisibilityPlayerModel)this.m_117386_()).setVisibility(VisibilityPlayerModel.Visibility.BODY);
                ((VisibilityPlayerModel)this.m_117386_()).m_7695_(matrixStackIn, bufferIn.m_6299_(bodyType), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (type != null) {
            ((VisibilityPlayerModel)this.m_117386_()).setVisibility(VisibilityPlayerModel.Visibility.ALL);
            ((VisibilityPlayerModel)this.m_117386_()).m_7695_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        ((VisibilityPlayerModel)this.m_117386_()).setVisibility(VisibilityPlayerModel.Visibility.NONE);
    }

    public static class VisibilityPlayerModel<T extends MinionEntity<?>>
    extends PlayerModel<T> {
        @NotNull
        private Visibility visibility = Visibility.NONE;
        @NotNull
        private final Collection<ModelPart> hatList = Collections.singleton(this.f_102809_);

        public VisibilityPlayerModel(ModelPart pRoot, boolean pSlim) {
            super(pRoot, pSlim);
        }

        @NotNull
        protected Iterable<ModelPart> m_5607_() {
            if (this.visibility.head) {
                return Iterables.concat((Iterable)super.m_5607_(), this.hatList);
            }
            return Collections.emptyList();
        }

        @NotNull
        protected Iterable<ModelPart> m_5608_() {
            if (this.visibility.body) {
                ArrayList parts = Lists.newArrayList((Iterable)super.m_5608_());
                parts.remove(this.f_102809_);
                return parts;
            }
            return Collections.emptyList();
        }

        public void setVisibility(@NotNull Visibility type) {
            this.visibility = type;
        }

        @Nullable
        public RenderType getRenderType(PlayerModel<T> model, ResourceLocation location, T entity) {
            Minecraft minecraft = Minecraft.m_91087_();
            boolean pBodyVisible = !entity.m_20145_();
            boolean translucent = !pBodyVisible && !entity.m_20177_((Player)minecraft.f_91074_);
            boolean flag2 = minecraft.m_91314_(entity);
            if (translucent) {
                return RenderType.m_110467_((ResourceLocation)location);
            }
            if (pBodyVisible) {
                return model.m_103119_(location);
            }
            return flag2 ? RenderType.m_110491_((ResourceLocation)location) : null;
        }

        public static enum Visibility {
            HEAD(true, false),
            BODY(false, true),
            NONE(false, false),
            ALL(true, true);

            private final boolean head;
            private final boolean body;

            private Visibility(boolean head, boolean body) {
                this.head = head;
                this.body = body;
            }
        }
    }
}

