/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.particle;

import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class FlyingBloodParticle
extends TextureSheetParticle {
    private final String TAG = "FlyingBloodParticle";
    private final double destX;
    private final double destY;
    private final double destZ;
    private final boolean direct;

    public FlyingBloodParticle(@NotNull ClientLevel world, double posX, double posY, double posZ, double destX, double destY, double destZ, int maxage, boolean direct, @NotNull ResourceLocation particleId, float scale) {
        super(world, posX, posY, posZ);
        this.f_107225_ = maxage;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.direct = direct;
        this.f_107227_ = 0.95f;
        this.f_107228_ = 0.05f;
        this.f_107229_ = 0.05f;
        double wayX = destX - this.f_107212_;
        double wayZ = destZ - this.f_107214_;
        double wayY = destY - this.f_107213_;
        if (direct) {
            this.f_107215_ = wayX / (double)maxage;
            this.f_107216_ = wayY / (double)maxage;
            this.f_107217_ = wayZ / (double)maxage;
        } else {
            this.f_107215_ = this.f_107208_.f_46441_.m_188500_() / 10.0 - 0.05 + wayX / (double)this.f_107225_;
            this.f_107216_ = this.f_107208_.f_46441_.m_188500_() / 10.0 - 0.01 + wayY / (double)this.f_107225_;
            this.f_107217_ = this.f_107208_.f_46441_.m_188500_() / 10.0 - 0.05 + wayZ / (double)this.f_107225_;
        }
        this.m_108337_(Minecraft.m_91087_().f_91061_.f_107296_.m_118316_(particleId));
        this.m_6569_(scale);
        this.f_107219_ = false;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        double wayX = this.destX - this.f_107212_;
        double wayY = this.destY - this.f_107213_;
        double wayZ = this.destZ - this.f_107214_;
        int tleft = this.f_107225_ - this.f_107224_;
        if (this.direct || (double)tleft < (double)this.f_107225_ / 1.2) {
            this.f_107215_ = wayX / (double)tleft;
            this.f_107216_ = wayY / (double)tleft;
            this.f_107217_ = wayZ / (double)tleft;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<FlyingBloodParticleOptions> {
        @Nullable
        public Particle createParticle(@NotNull FlyingBloodParticleOptions typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingBloodParticle(worldIn, x, y, z, typeIn.targetX(), typeIn.targetY(), typeIn.targetZ(), typeIn.getMaxAge(), typeIn.direct(), typeIn.texture(), typeIn.scale());
        }
    }
}

