/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageCombination(CombineType combineType) {
    static SMessageCombination fromBytes(FriendlyByteBuf buf) {
        return new SMessageCombination(CombineType.values()[buf.readShort()]);
    }

    static void toBytes(SMessageCombination msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.combineType.ordinal());
    }

    public static enum CombineType {
        COMBINE_IN_INVENTORY,
        COLOR_SMOKE_BALL;

    }

    public static class Handler {
        static void handle(final SMessageCombination message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayer player = ctx.getSender();
                        if (player != null && player.m_7500_()) {
                            if (message.combineType() == CombineType.COLOR_SMOKE_BALL) {
                                ModTriggers.COMBINE_IN_INVENTORY.trigger(player);
                                ModTriggers.COLOR_SMOKE_BALL.trigger(player);
                            } else {
                                ModTriggers.COMBINE_IN_INVENTORY.trigger(player);
                            }
                        }
                    }
                });
            }
        }
    }
}

