/*
 * Decompiled with CFR 0.152.
 */
package com.wanmine.ghosts.entities;

import com.wanmine.ghosts.entities.goals.GhostFollowOwnerGoal;
import com.wanmine.ghosts.entities.goals.GhostPlaceGoal;
import com.wanmine.ghosts.entities.goals.GhostsWanderGoal;
import com.wanmine.ghosts.entities.goals.StayWhenOrderedToGoal;
import com.wanmine.ghosts.entities.variants.GhostVariant;
import com.wanmine.ghosts.registries.ModItems;
import com.wanmine.ghosts.registries.ModSounds;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.InstancedAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GhostEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache factory = new InstancedAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_RESET_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BLINK_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLINK_ANIM_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_UNENCHANT = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cdUnenchant = 0;

    public GhostEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.m_7105_(false);
        this.m_6126_();
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new StayWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GhostFollowOwnerGoal(this, 8.0, 15.0f, 2.0f));
        this.f_21345_.m_25352_(7, (Goal)new GhostPlaceGoal((PathfinderMob)this, Ingredient.m_204132_(ModItems.PLACEABLES), state -> true, 10, 10){

            @Override
            protected boolean m_6465_(LevelReader level, BlockPos pos) {
                return level.m_46859_(pos.m_7494_()) && level.m_45517_(LightLayer.BLOCK, pos) < 4 && level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP);
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new GhostsWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier setAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    public boolean m_142535_(float p_148989_, float p_148990_, @NotNull DamageSource p_148991_) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SHOULD_RESET_CD, (Object)false);
        this.f_19804_.m_135372_(BLINK_CD, (Object)0);
        this.f_19804_.m_135372_(BLINK_ANIM_CD, (Object)0);
        this.f_19804_.m_135372_(SHOULD_UNENCHANT, (Object)false);
    }

    public void setHoldItem(ItemStack holdItem) {
        if (this.shouldUnechant()) {
            this.setShouldUnenchant(false);
            this.setCdUnenchant(0);
        }
        if (holdItem.m_41793_()) {
            this.setShouldUnenchant(true);
            this.setCdUnenchant(82);
        }
        this.m_21468_(EquipmentSlot.MAINHAND, holdItem);
    }

    public ItemStack getHoldItem() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public int getCdUnenchant() {
        return this.cdUnenchant;
    }

    public void setCdUnenchant(int cd) {
        this.cdUnenchant = cd;
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public GhostVariant getVariant() {
        return GhostVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(GhostVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant & 0xFF));
    }

    public int getBlinkCd() {
        return (Integer)this.f_19804_.m_135370_(BLINK_CD);
    }

    public void setBlinkCd(int cd) {
        this.f_19804_.m_135381_(BLINK_CD, (Object)cd);
    }

    public int getBlinkAnimCd() {
        return (Integer)this.f_19804_.m_135370_(BLINK_ANIM_CD);
    }

    public void setBlinkAnimCd(int cd) {
        this.f_19804_.m_135381_(BLINK_ANIM_CD, (Object)cd);
    }

    public void setShouldResetCd(boolean shouldResetCd) {
        this.f_19804_.m_135381_(SHOULD_RESET_CD, (Object)shouldResetCd);
    }

    public boolean getShouldResetCd() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RESET_CD);
    }

    private void setShouldUnenchant(boolean shouldUnenchant) {
        this.f_19804_.m_135381_(SHOULD_UNENCHANT, (Object)shouldUnenchant);
    }

    private boolean shouldUnechant() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_UNENCHANT);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
        compound.m_128405_("CdUnenchant", this.getCdUnenchant());
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return this.m_21830_((LivingEntity)player) && this.m_21824_() || itemstack.m_150930_(Items.f_151079_) && !this.m_21824_() ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_151079_) && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_21530_();
                this.f_21344_.m_26573_();
                level.m_7605_((Entity)this, (byte)7);
            } else {
                level.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_151079_) && this.m_21824_() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(4.0f);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!itemstack.m_150930_(Items.f_151079_) && this.m_21824_() && this.m_21830_((LivingEntity)player) && this.getHoldItem().m_41619_() && !itemstack.m_41619_()) {
            ItemStack stack = itemstack.m_41777_();
            this.setHoldItem(stack);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(itemstack.m_41613_());
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_() && this.m_21824_() && player.m_6144_() && this.m_21830_((LivingEntity)player) && !this.getHoldItem().m_41619_()) {
            this.m_5552_(this.getHoldItem(), 0.5f);
            this.setHoldItem(ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            this.m_21839_(!this.m_21827_());
            this.f_21344_.m_26573_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_216339_(2, 4);
    }

    public void m_8119_() {
        ItemStack heldItemStack;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getBlinkCd() > 0) {
            this.setBlinkCd(this.getBlinkCd() - 1);
        } else if (this.getBlinkAnimCd() > 0) {
            this.setBlinkAnimCd(this.getBlinkAnimCd() - 1);
        } else if (this.getShouldResetCd()) {
            this.setShouldResetCd(false);
            this.setBlinkCd(this.f_19796_.m_216339_(80, 120));
        } else {
            this.setShouldResetCd(true);
            this.setBlinkAnimCd(6);
        }
        if (this.getCdUnenchant() > 0) {
            this.setCdUnenchant(this.getCdUnenchant() - 1);
        }
        if ((heldItemStack = this.getHoldItem()).m_41793_() && this.getCdUnenchant() == 0) {
            if (!this.shouldUnechant()) {
                this.startUnenchantAnim();
            } else {
                this.m_5552_(this.removeEnchants(heldItemStack), 0.5f);
                this.setHoldItem(ItemStack.f_41583_);
                this.setShouldUnenchant(false);
            }
        }
    }

    private void startUnenchantAnim() {
        this.setCdUnenchant(82);
        this.setShouldUnenchant(true);
    }

    private ItemStack removeEnchants(ItemStack item) {
        ItemStack itemstack = item.m_41777_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ExperienceOrb.m_147082_((ServerLevel)level2, (Vec3)this.m_20318_(0.0f), (int)this.getExperienceFromItem(itemstack));
        }
        if (itemstack.m_41785_().size() > 0) {
            int i = this.f_19796_.m_188503_(itemstack.m_41785_().size());
            itemstack.m_41785_().remove(i);
        }
        itemstack.m_41749_("StoredEnchantments");
        itemstack.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
        return itemstack.m_41777_();
    }

    private int getExperienceFromItem(ItemStack p_39637_) {
        int l = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)p_39637_);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            l += enchantment.m_6183_(integer.intValue());
        }
        return l;
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Variant")) {
            this.setVariant(compound.m_128451_("Variant"));
        }
        if (compound.m_128441_("CdUnenchant")) {
            this.setCdUnenchant(compound.m_128451_("CdUnenchant"));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GHOST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GHOST_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.GHOST_HURT.get();
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setVariant(levelAccessor.m_213780_().m_188499_() ? GhostVariant.MUSHROOM : GhostVariant.NORMAL);
        return super.m_6518_(levelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    private <E extends GeoAnimatable> PlayState bodyAC(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_move"));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_sitting"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState blinkAC(AnimationState<E> event) {
        if (this.getBlinkCd() == 0) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_blink"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState armsAC(AnimationState<E> event) {
        if (!this.getHoldItem().m_41619_()) {
            if (this.shouldUnechant()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_unenchant"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_arms_hold"));
            }
        } else if (!this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop(event.isMoving() ? "ghost_move_arms" : "ghost_idle_arms"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "ghost_animation_controller_body", 1, this::bodyAC).setOverrideEasingType(EasingType.LINEAR)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "ghost_animation_controller_arms", 1, this::armsAC)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "ghost_animation_controller_blink", 1, this::blinkAC)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

