/*
 * Decompiled with CFR 0.152.
 */
package com.wanmine.ghosts.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public abstract class BaseGhostRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    protected T ghostEntity;
    protected RenderType renderType;
    protected int cachedPackedLight;

    protected BaseGhostRenderer(EntityRendererProvider.Context context, GeoModel<T> modelProvider) {
        super(context, modelProvider);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.ghostEntity = animatable;
        this.cachedPackedLight = packedLight;
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ItemStack heldItemStack = this.ghostEntity.m_6844_(EquipmentSlot.MAINHAND);
        String boneName = bone.getName();
        if (heldItemStack != null && !heldItemStack.m_41619_() && boneName.equals("item")) {
            poseStack.m_85836_();
            this.moveAndRotateToBone(poseStack, bone);
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            Minecraft.m_91087_().m_91291_().m_269128_(heldItemStack, ItemDisplayContext.GROUND, this.cachedPackedLight, packedOverlay, poseStack, bufferSource, animatable.m_9236_(), 0);
            poseStack.m_85849_();
            buffer = bufferSource.m_6299_(this.renderType);
        }
        if (boneName.equals("glow")) {
            return;
        }
        if (boneName.equals("main")) {
            packedLight = 0xF000F0;
        } else if (boneName.equals("plant")) {
            packedLight = this.cachedPackedLight;
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        this.renderType = RenderType.m_110473_((ResourceLocation)texture);
        return this.renderType;
    }

    protected void moveAndRotateToBone(PoseStack poseStack, GeoBone bone) {
        poseStack.m_252880_(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        poseStack.m_252880_(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }
}

