/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class FrostshieldModifier
extends DurabilityShieldModifier
implements ModifyDamageModifierHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.MODIFY_HURT);
    }

    @Override
    public int getPriority() {
        return 175;
    }

    @Override
    public int getShieldCapacity(IToolStackView tool, ModifierEntry modifier) {
        return (int)(modifier.getEffectiveLevel() * 100.0f * tool.getMultiplier(ToolStats.DURABILITY));
    }

    @Override
    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return this.getShield(tool) > 0 ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        if (this.getShield(tool) > 0) {
            return 0xAAFFFF;
        }
        return -1;
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (source.m_269533_(DamageTypeTags.f_268419_)) {
            int capacity = this.getShieldCapacity(tool, modifier);
            int current = this.getShield(tool);
            if (current < capacity) {
                int added = Math.min(capacity - current, Mth.m_14167_((float)amount));
                this.setShield(tool.getPersistentData(), current + added);
                amount -= (float)added;
            }
        }
        return amount;
    }
}

