/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.tables.block.TabbedTableBlock;
import slimeknights.tconstruct.tables.block.entity.chest.AbstractChestBlockEntity;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;

public class ChestBlock
extends TabbedTableBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)2.5, (double)15.0, (double)2.5), Block.m_49796_((double)13.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)2.5), Block.m_49796_((double)13.5, (double)0.0, (double)13.5, (double)15.5, (double)15.0, (double)15.5), Block.m_49796_((double)0.5, (double)0.0, (double)13.5, (double)2.5, (double)15.0, (double)15.5)});
    private final BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntity;
    private final boolean dropsItems;

    public ChestBlock(BlockBehaviour.Properties builder, BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntity, boolean dropsItems) {
        super(builder);
        this.blockEntity = blockEntity;
        this.dropsItems = dropsItems;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return this.blockEntity.m_155267_(pPos, pState);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("TinkerData", 10)) {
            CompoundTag tinkerData = tag.m_128469_("TinkerData");
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof AbstractChestBlockEntity) {
                AbstractChestBlockEntity chest = (AbstractChestBlockEntity)te;
                chest.readInventory(tinkerData);
            }
        }
    }

    @Override
    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        IChestItemHandler itemHandler;
        ItemStack rest;
        AbstractChestBlockEntity chest;
        BlockEntity te = worldIn.m_7702_(pos);
        Inventory playerInventory = player.m_150109_();
        ItemStack heldItem = playerInventory.m_36056_();
        if (!heldItem.m_41619_() && te instanceof AbstractChestBlockEntity && (chest = (AbstractChestBlockEntity)te).canInsert(player, heldItem) && ((rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = chest.getItemHandler()), (ItemStack)heldItem, (boolean)false)).m_41619_() || rest.m_41613_() < heldItem.m_41613_())) {
            playerInventory.f_35974_.set(playerInventory.f_35977_, (Object)rest);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void dropInventoryItems(BlockState state, Level worldIn, BlockPos pos, IItemHandler inventory) {
        if (this.dropsItems) {
            ChestBlock.dropInventoryItems((Level)worldIn, (BlockPos)pos, (IItemHandler)inventory);
        }
    }
}

