/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module.alloying;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;

public class MixerAlloyTank
implements IMutableAlloyTank {
    private final MantleBlockEntity parent;
    private final IFluidHandler outputTank;
    private int temperature = 0;
    private final Map<Direction, LazyOptional<IFluidHandler>> inputs = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>> listeners = new EnumMap<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>>(Direction.class);
    @Nullable
    private IFluidHandler[] indexedList = null;
    private boolean needsRefresh = true;
    private int currentTanks = 0;

    @Override
    public int getTanks() {
        this.checkTanks();
        return this.currentTanks;
    }

    private IFluidHandler[] indexTanks() {
        if (this.indexedList == null) {
            this.indexedList = new IFluidHandler[this.currentTanks];
            if (this.currentTanks > 0) {
                int nextTank = 0;
                for (Direction direction : Direction.values()) {
                    LazyOptional<IFluidHandler> handler;
                    if (direction == Direction.DOWN || !(handler = this.inputs.getOrDefault(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty())).isPresent()) continue;
                    this.indexedList[nextTank] = (IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE);
                    ++nextTank;
                }
            }
        }
        return this.indexedList;
    }

    public IFluidHandler getFluidHandler(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return EmptyFluidHandler.INSTANCE;
        }
        return this.indexTanks()[tank];
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].getFluidInTank(0);
    }

    @Override
    public FluidStack drain(int tank, FluidStack fluidStack) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean canFit(FluidStack fluid, int removed) {
        this.checkTanks();
        return this.outputTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
    }

    @Override
    public int fill(FluidStack fluidStack) {
        return this.outputTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    private void checkTanks() {
        Level world = this.parent.m_58904_();
        if (world == null) {
            return;
        }
        if (this.needsRefresh) {
            for (Direction direction : Direction.values()) {
                BlockPos target;
                if (direction == Direction.DOWN || this.inputs.containsKey(direction) || !world.m_8055_(target = this.parent.m_58899_().m_121945_(direction)).m_204336_(TinkerTags.Blocks.ALLOYER_TANKS)) continue;
                BlockEntity te = world.m_7702_(target);
                if (te != null) {
                    LazyOptional capability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_());
                    if (capability.isPresent()) {
                        capability.addListener(this.listeners.computeIfAbsent(direction, dir -> new WeakConsumerWrapper((Object)this, (self, handler) -> {
                            if (handler == self.inputs.get(dir)) {
                                this.refresh((Direction)dir, false);
                            }
                        })));
                        this.inputs.put(direction, (LazyOptional<IFluidHandler>)capability);
                        ++this.currentTanks;
                        continue;
                    }
                    this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
                    continue;
                }
                this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
            }
            this.needsRefresh = false;
        }
    }

    public void refresh(Direction direction, boolean checkInput) {
        if (direction == Direction.DOWN) {
            return;
        }
        if (!checkInput || this.inputs.containsKey(direction) && this.inputs.get(direction).isPresent()) {
            --this.currentTanks;
        }
        this.inputs.remove(direction);
        this.needsRefresh = true;
        this.indexedList = null;
    }

    public MixerAlloyTank(MantleBlockEntity parent, IFluidHandler outputTank) {
        this.parent = parent;
        this.outputTank = outputTank;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }
}

