/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.utils.IdParser;
import slimeknights.tconstruct.shared.command.argument.TinkerSuggestionProvider;

public class ModifierHookArgument
implements ArgumentType<ModuleHook<?>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("tconstruct:tool_stats", "tconstruct:tooltip");
    private static final DynamicCommandExceptionType HOOK_NOT_FOUND = new DynamicCommandExceptionType(name -> TConstruct.makeTranslation("command", "modifier_hook.not_found", name));

    public ModuleHook<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation loc = IdParser.read("tconstruct", reader);
        ModuleHook hook = (ModuleHook)ModifierHooks.LOADER.getValue(loc);
        if (hook == null) {
            throw HOOK_NOT_FOUND.create((Object)loc);
        }
        return hook;
    }

    public static ModuleHook<?> getModifier(CommandContext<CommandSourceStack> context, String name) {
        return (ModuleHook)context.getArgument(name, ModuleHook.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return TinkerSuggestionProvider.suggestResource("tconstruct", ModifierHooks.LOADER.getKeys(), builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private ModifierHookArgument() {
    }

    public static ModifierHookArgument modifierHook() {
        return new ModifierHookArgument();
    }
}

