/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface SlotStackModifierHook {
    default public boolean overrideStackedOnOther(IToolStackView heldTool, ModifierEntry modifier, Slot slot, Player player) {
        return false;
    }

    default public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
        return false;
    }

    public static boolean overrideStackedOnOther(ItemStack held, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && held.m_41613_() == 1 && slot.m_150651_(player)) {
            ToolStack tool = ToolStack.from(held);
            for (ModifierEntry entry : tool.getModifiers()) {
                if (!entry.getHook(ModifierHooks.SLOT_STACK).overrideStackedOnOther(tool, entry, slot, player)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slotStack.m_41613_() == 1 && slot.m_150651_(player)) {
            ToolStack tool = ToolStack.from(slotStack);
            for (ModifierEntry entry : tool.getModifiers()) {
                if (!entry.getHook(ModifierHooks.SLOT_STACK).overrideOtherStackedOnMe(tool, entry, held, slot, player, access)) continue;
                return true;
            }
        }
        return false;
    }

    public record FirstMerger(Collection<SlotStackModifierHook> modules) implements SlotStackModifierHook
    {
        @Override
        public boolean overrideStackedOnOther(IToolStackView heldTool, ModifierEntry modifier, Slot slot, Player player) {
            for (SlotStackModifierHook module : this.modules) {
                if (!module.overrideStackedOnOther(heldTool, modifier, slot, player)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
            for (SlotStackModifierHook module : this.modules) {
                if (!module.overrideOtherStackedOnMe(slotTool, modifier, held, slot, player, access)) continue;
                return true;
            }
            return false;
        }
    }
}

