/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BookPileHorizontalBlock
extends BookPileBlock {
    private static final VoxelShape SHAPE_1_Z = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_1_X = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_2_Z = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_2_X = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0);
    private static final VoxelShape SHAPE_3_Z = Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_3_X = Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)10.0, (double)15.0);
    private static final VoxelShape SHAPE_4_Z = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_4_X = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BookPileHorizontalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOKS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() instanceof BookPileBlock) {
            return (BlockState)blockstate.m_61124_((Property)BOOKS, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)BOOKS) + 1));
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidState.m_76152_() == Fluids.f_76193_ && fluidState.m_76186_() == 8;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BookPileBlockTile(pPos, pState, true);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean x = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X;
        return BookPileHorizontalBlock.getVoxelShape(state, x);
    }

    private static VoxelShape getVoxelShape(BlockState state, boolean x) {
        return switch ((Integer)state.m_61143_((Property)BOOKS)) {
            default -> {
                if (x) {
                    yield SHAPE_1_X;
                }
                yield SHAPE_1_Z;
            }
            case 2 -> {
                if (x) {
                    yield SHAPE_2_X;
                }
                yield SHAPE_2_Z;
            }
            case 3 -> {
                if (x) {
                    yield SHAPE_3_X;
                }
                yield SHAPE_3_Z;
            }
            case 4 -> x ? SHAPE_4_X : SHAPE_4_Z;
        };
    }

    @Override
    protected int getBookIndex(BlockState state, BlockPos pos, Vec3 location) {
        double dist;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        double d = dist = dir.m_122434_() == Direction.Axis.Z ? location.f_82479_ - (double)pos.m_123341_() : location.f_82481_ - (double)pos.m_123343_();
        if (dir == Direction.NORTH || dir == Direction.EAST) {
            dist = 1.0 - dist;
        }
        double f = (dist -= (1.0 - BookPileHorizontalBlock.getVoxelShape(state, false).m_83215_().m_82362_()) / 2.0) / 0.25;
        return Mth.m_14045_((int)((int)f), (int)0, (int)((Integer)state.m_61143_((Property)BOOKS) - 1));
    }
}

