/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.block.BlockDragonforgeInput;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class TileEntityDragonforgeInput
extends BlockEntity {
    private static final int LURE_DISTANCE = 50;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private int ticksSinceDragonFire;
    private TileEntityDragonforge core = null;

    public TileEntityDragonforgeInput(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafTileEntityRegistry.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public static void tick(Level level, BlockPos position, BlockState state, TileEntityDragonforgeInput forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            BlockEntity tileentity = level.m_7702_(position);
            level.m_46597_(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.m_6339_();
                level.m_151523_(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    protected void lureDragons() {
        Vec3 targetPosition = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
        AABB searchArea = new AABB((double)this.f_58858_.m_123341_() - 50.0, (double)this.f_58858_.m_123342_() - 50.0, (double)this.f_58858_.m_123343_() - 50.0, (double)this.f_58858_.m_123341_() + 50.0, (double)this.f_58858_.m_123342_() + 50.0, (double)this.f_58858_.m_123343_() + 50.0);
        boolean dragonSelected = false;
        for (EntityDragonBase dragon : this.f_58857_.m_45976_(EntityDragonBase.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType.getIntFromType() && (dragon.isChained() || dragon.m_21824_()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.f_58858_;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.f_58858_) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    public void resetCore() {
        this.core = null;
    }

    private boolean canSeeInput(EntityDragonBase dragon, Vec3 target) {
        if (target != null) {
            BlockHitResult rayTrace = this.f_58857_.m_45547_(new ClipContext(dragon.getHeadPosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
            double distance = dragon.getHeadPosition().m_82554_(rayTrace.m_82450_());
            return distance < (double)(10.0f + dragon.m_20205_());
        }
        return false;
    }

    private BlockState getDeactivatedState() {
        return switch (this.getDragonType()) {
            case 0 -> (BlockState)((Block)IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            case 1 -> (BlockState)((Block)IafBlockRegistry.DRAGONFORGE_ICE_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            case 2 -> (BlockState)((Block)IafBlockRegistry.DRAGONFORGE_LIGHTNING_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            default -> (BlockState)((Block)IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.get()).m_49966_().m_61124_((Property)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
        };
    }

    private int getDragonType() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() == IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.get()) {
            return 0;
        }
        if (state.m_60734_() == IafBlockRegistry.DRAGONFORGE_ICE_INPUT.get()) {
            return 1;
        }
        if (state.m_60734_() == IafBlockRegistry.DRAGONFORGE_LIGHTNING_INPUT.get()) {
            return 2;
        }
        return 0;
    }

    private boolean isActive() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return state.m_60734_() instanceof BlockDragonforgeInput && (Boolean)state.m_61143_((Property)BlockDragonforgeInput.ACTIVE) != false;
    }

    private TileEntityDragonforge getConnectedTileEntity(BlockPos position) {
        for (Direction facing : HORIZONTALS) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(position.m_121945_(facing));
            if (!(blockEntity instanceof TileEntityDragonforge)) continue;
            TileEntityDragonforge forge = (TileEntityDragonforge)blockEntity;
            return forge;
        }
        return null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (this.core != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.core.getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }
}

