/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.kubejs.affixjs;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.BasicAffixBuilder;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.integration.kubejs.ChampionsKubeJSPlugin;
import top.theillusivec4.champions.common.integration.kubejs.affixjs.AffixBehavior;

public class CustomAffix
extends BasicAffix {
    private final Builder builder;
    private final AffixBehavior behavior;

    public CustomAffix(Builder builder) {
        this.builder = builder;
        this.behavior = builder.behavior;
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        if (this.behavior.onInitialSpawnCallback != null) {
            this.behavior.onInitialSpawnCallback.onInitialSpawn(champion);
        }
    }

    @Override
    public void onSpawn(IChampion champion) {
        if (this.behavior.onSpawnCallback != null) {
            this.behavior.onSpawnCallback.onSpawn(champion);
        }
    }

    @Override
    public void onServerUpdate(IChampion champion) {
        if (this.behavior.onServerUpdateCallback != null) {
            this.behavior.onServerUpdateCallback.onServerUpdate(champion);
        }
    }

    @Override
    public void onClientUpdate(IChampion champion) {
        if (this.behavior.onClientUpdateCallback != null) {
            this.behavior.onClientUpdateCallback.onClientUpdate(champion);
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        if (this.behavior.onAttackCallback != null) {
            return this.behavior.onAttackCallback.onAttack(champion, target, source, amount);
        }
        return super.onAttack(champion, target, source, amount);
    }

    @Override
    public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        if (this.behavior.onAttackedCallback != null) {
            return this.behavior.onAttackedCallback.onAttacked(champion, source, amount);
        }
        return super.onAttacked(champion, source, amount);
    }

    @Override
    public float onHurt(IChampion champion, DamageSource source, float amount, float newAmount) {
        if (this.behavior.onHurtCallback != null) {
            return this.behavior.onHurtCallback.onHurt(champion, source, amount, newAmount);
        }
        return super.onHurt(champion, source, amount, newAmount);
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (this.behavior.onHealCallback != null) {
            return this.behavior.onHealCallback.onHeal(champion, amount, newAmount);
        }
        return super.onHeal(champion, amount, newAmount);
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        if (this.builder.behavior.onDamageCallback != null) {
            return this.builder.behavior.onDamageCallback.onDamage(champion, source, amount, newAmount);
        }
        return super.onDamage(champion, source, amount, newAmount);
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        if (this.builder.behavior.onDeathCallback != null) {
            return this.builder.behavior.onDeathCallback.onDeath(champion, source);
        }
        return super.onDeath(champion, source);
    }

    public static class Builder
    extends BuilderBase<CustomAffix> {
        public AffixBehavior behavior;
        public BasicAffixBuilder<CustomAffix> basicBuilder = new BasicAffixBuilder<CustomAffix>(() -> null);

        public Builder(ResourceLocation id) {
            super(id);
            this.behavior = new AffixBehavior();
        }

        public RegistryInfo<?> getRegistryType() {
            return ChampionsKubeJSPlugin.CUSTOM_AFFIX;
        }

        public Builder behavior(Consumer<AffixBehavior> consumer) {
            consumer.accept(this.behavior);
            return this;
        }

        public Builder settings(Consumer<BasicAffixBuilder<?>> consumer) {
            consumer.accept(this.basicBuilder);
            return this;
        }

        public CustomAffix createObject() {
            CustomAffix affix = new CustomAffix(this);
            this.basicBuilder.setAffixSupplier(() -> affix);
            return this.basicBuilder.build();
        }
    }
}

