/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;

public abstract class UpgradeItem
extends Item {
    private final Component tooltipComponent;

    public UpgradeItem(Item.Properties pProperties, String tooltipKey) {
        super(pProperties);
        this.tooltipComponent = tooltipKey == null ? null : Component.m_237115_((String)("item.travelersbackpack." + tooltipKey + "_tooltip")).m_130940_(ChatFormatting.BLUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        if (this.tooltipComponent != null) {
            tooltipComponents.add(this.tooltipComponent);
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.upgrade_apply_tooltip"));
    }

    public boolean isTickingUpgrade() {
        return false;
    }

    public boolean requiresEquippedBackpack() {
        return true;
    }

    public abstract Class<? extends UpgradeBase<?>> getUpgradeClass();

    public abstract TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade();
}

