/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class CobaltShrubFeature
extends Feature<NoneFeatureConfiguration> {
    public CobaltShrubFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkReplaceable((LevelAccessor)level, pos)) {
            return false;
        }
        this.placeShrub((LevelAccessor)level, pos, randomSource);
        return true;
    }

    public void placeShrub(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Direction direction;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        int size = randomSource.m_188503_(4);
        int dir = randomSource.m_188503_(4);
        switch (dir) {
            case 0: {
                Direction direction2 = Direction.EAST;
                break;
            }
            case 1: {
                Direction direction2 = Direction.SOUTH;
                break;
            }
            case 2: {
                Direction direction2 = Direction.WEST;
                break;
            }
            default: {
                Direction direction2 = direction = Direction.NORTH;
            }
        }
        if (size == 0) {
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            this.placeTop(level, (BlockPos)placePos, randomSource);
        } else if (size == 1) {
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            this.placeTop(level, (BlockPos)placePos, randomSource);
        } else if (size == 2) {
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            this.placeTop(level, (BlockPos)placePos, randomSource);
            if (randomSource.m_188503_(4) == 0) {
                placePos.m_122173_(direction);
                this.placeLogBlock(level, (BlockPos)placePos, randomSource, direction.m_122434_());
                placePos.m_122173_(direction);
                placePos.m_122173_(Direction.UP);
                this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
                placePos.m_122173_(Direction.UP);
                this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
                this.placeTop(level, (BlockPos)placePos, randomSource);
            }
        } else if (size == 3) {
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            this.placeTop(level, (BlockPos)placePos, randomSource);
            placePos.m_122173_(direction);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, direction.m_122434_());
            placePos.m_122173_(direction);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLogBlock(level, (BlockPos)placePos, randomSource, Direction.Axis.Y);
            this.placeTop(level, (BlockPos)placePos, randomSource);
        }
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122012_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122019_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122029_().m_7494_(), randomSource);
        this.placeLeavesBlock(level, pos.m_122024_().m_7494_(), randomSource);
    }

    public void placeLogBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, Direction.Axis axis) {
        boolean isBase = false;
        if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            isBase = true;
        }
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RuBlocks.BRIMSPROUT_NYLIUM.get())) {
            level.m_7731_(pos, Blocks.f_50134_.m_49966_(), 2);
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos, Blocks.f_50730_.m_49966_(), 2);
        } else if (CobaltShrubFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)((Block)RuBlocks.COBALT_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        } else {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.BRIMSPROUT_NYLIUM.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50134_.m_49966_(), 2);
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50730_.m_49966_(), 2);
        } else if (CobaltShrubFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7495_())) {
            level.m_7731_(pos.m_7495_(), (BlockState)((Block)RuBlocks.COBALT_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        }
    }

    public void placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)((Block)RuBlocks.COBALT_WEBBING.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return CobaltShrubFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, CobaltShrubFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, CobaltShrubFeature::isReplaceableBlock);
    }
}

