/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.FallenTreeConfiguration;

public class FallenSnowTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenSnowTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfiguration> context) {
        FallenTreeConfiguration treeConfiguration = (FallenTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int direction = randomSource.m_188503_(4);
        int height = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        if (level.m_151570_(pos)) {
            return false;
        }
        int placeCheck = 0;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        while (placeCheck <= height && level.m_8055_(placePos.m_7495_()).m_60783_((BlockGetter)level, placePos.m_7495_(), Direction.UP)) {
            if (!level.m_8055_(placePos.m_7495_()).m_60783_((BlockGetter)level, placePos.m_7495_(), Direction.UP)) {
                return true;
            }
            if (!FallenSnowTreeFeature.isReplaceable((LevelSimulatedReader)level, (BlockPos)placePos)) {
                return true;
            }
            if (direction == 0) {
                if (placeCheck == 0) {
                    this.placeStump((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                    placePos.m_122173_(Direction.NORTH);
                } else {
                    this.placeLogZ((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                    this.placeSnowAbove((LevelAccessor)level, placePos.m_7494_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                }
                if (placeCheck == height && height > treeConfiguration.minimumSize + 1 && treeConfiguration.hasLeaves) {
                    this.placeLeavesBlobNorth((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                }
                placePos.m_122173_(Direction.NORTH);
                ++placeCheck;
                continue;
            }
            if (direction == 1) {
                if (placeCheck == 0) {
                    this.placeStump((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                    placePos.m_122173_(Direction.SOUTH);
                } else {
                    this.placeLogZ((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                    this.placeSnowAbove((LevelAccessor)level, placePos.m_7494_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                }
                if (placeCheck == height && height > treeConfiguration.minimumSize + 1 && treeConfiguration.hasLeaves) {
                    this.placeLeavesBlobSouth((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                }
                placePos.m_122173_(Direction.SOUTH);
                ++placeCheck;
                continue;
            }
            if (direction == 2) {
                if (placeCheck == 0) {
                    this.placeStump((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                    placePos.m_122173_(Direction.EAST);
                } else {
                    this.placeLogX((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_7494_(), randomSource, treeConfiguration);
                    this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                }
                if (placeCheck == height && height > treeConfiguration.minimumSize + 1 && treeConfiguration.hasLeaves) {
                    this.placeLeavesBlobEast((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                }
                placePos.m_122173_(Direction.EAST);
                ++placeCheck;
                continue;
            }
            if (direction != 3) continue;
            if (placeCheck == 0) {
                this.placeStump((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                placePos.m_122173_(Direction.WEST);
            } else {
                this.placeLogX((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_7494_(), randomSource, treeConfiguration);
                this.placeSnow((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
            }
            if (placeCheck == height && height > treeConfiguration.minimumSize + 1 && treeConfiguration.hasLeaves) {
                this.placeLeavesBlobWest((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.WEST);
            ++placeCheck;
        }
        return true;
    }

    public boolean placeStump(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (FallenSnowTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, treeConfiguration.stumpProvider.m_213972_(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLogX(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (FallenSnowTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLogZ(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (FallenSnowTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeSnow(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_() && randomSource.m_188503_(5) == 0 && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeSnowAbove(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_() && randomSource.m_188503_(2) == 0 && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLeaves(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_() || level.m_8055_(pos).m_60713_(Blocks.f_152543_)) {
            if (level.m_8055_(pos).m_60734_() instanceof DoublePlantBlock) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
            }
            level.m_7731_(pos, treeConfiguration.foliageProvider.m_213972_(randomSource, pos), 2);
        }
        return true;
    }

    public boolean placeLeavesLayerX(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_().m_122019_(), randomSource, treeConfiguration);
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_().m_122019_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_().m_122019_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_122012_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_122012_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_122019_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_122019_().m_7495_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesLayerZ(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos.m_7495_().m_122024_(), randomSource, treeConfiguration);
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7494_().m_7494_().m_122024_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_7495_().m_7495_().m_122024_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_122029_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_122029_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_122024_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_122024_().m_7495_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlobNorth(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesLayerZ(level, pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesLayerZ(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_(), randomSource, treeConfiguration);
        }
        this.placeLeaves(level, pos.m_122012_(), randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlobSouth(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesLayerZ(level, pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesLayerZ(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_(), randomSource, treeConfiguration);
        }
        this.placeLeaves(level, pos.m_122019_(), randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlobEast(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesLayerX(level, pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesLayerX(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_(), randomSource, treeConfiguration);
        }
        this.placeLeaves(level, pos.m_122029_(), randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122029_().m_122019_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlobWest(LevelAccessor level, BlockPos pos, RandomSource randomSource, FallenTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesLayerX(level, pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesLayerX(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeaves(level, pos, randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122019_(), randomSource, treeConfiguration);
        }
        this.placeLeaves(level, pos.m_122024_(), randomSource, treeConfiguration);
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_7494_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_7495_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(4) != 0) {
            this.placeLeaves(level, pos.m_122024_().m_122019_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, FallenSnowTreeFeature::isReplaceableBlock);
    }
}

