/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class FrozenBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseFrozenSpawning(boolean addPolarBear) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 10, 2, 3));
        if (addPolarBear) {
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 1, 1, 2));
        }
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnBuilder, (int)95, (int)5, (int)20, (boolean)false);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20481_, 80, 4, 4));
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseFrozenGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseFrozenTaigaGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome coldBorealTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-9922472).m_48045_(-9917084).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184220_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenTaigaGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARCH_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GOLDEN_LARCH_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_LARCH_TREE);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOWBELLE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.LARCH_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.0f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome coldDeciduousForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(5614468).m_48045_(6732196).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184225_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_WITH_BRANCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_OAK_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_RED_MAPLE_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SPRUCE_TREE_TALL_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_OAK_TREE_SPARSE);
        RuBiomeDefaultFeatures.bleedingHeart(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOWBELLE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SPRUCE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-1.5f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome frozenPineTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-9922472).m_48045_(-9917084).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184220_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenTaigaGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_TALL_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_SHRUB_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_DIRT);
        RuBiomeDefaultFeatures.bleedingHeart(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOW_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-0.5f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome frozenTundra(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-5207984).m_48045_(-5215920).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184220_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SPRUCE_TREE_TALL_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_TREE_SHRUB_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SINGLE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SPRUCE_TREE_SHRUB_DENSE);
        RuBiomeDefaultFeatures.bleedingHeart(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOWBELLE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOW_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SPRUCE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(true);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-1.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome icyHeights(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-9913745).m_48045_(-9059189).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184224_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SCOTTS_PINE_TREE_MOUNTAIN_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.DEAD_SCOTTS_PINE_TREE_MOUNTAIN_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_SHRUB_ON_SNOW_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_SNOW);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.ROCK_ON_SNOW);
        RuBiomeDefaultFeatures.bleedingHeart(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOW_GRASS);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-1.0f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome spires(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(FrozenBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-11097502).m_48045_(-11097488).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184225_));
        BiomeGenerationSettings.Builder biomeBuilder = FrozenBiomes.baseFrozenGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.ICICLE_UP);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ICE_SPIRE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SPRUCE_TREE_TALL_ON_SNOW);
        RuBiomeDefaultFeatures.bleedingHeart(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SNOW_GRASS);
        MobSpawnSettings.Builder spawnBuilder = FrozenBiomes.baseFrozenSpawning(true);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-2.0f).m_47611_(0.95f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

