/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thalassophobia.entity;

import javax.annotation.Nullable;
import net.mcreator.thalassophobia.entity.CnidariaEntity;
import net.mcreator.thalassophobia.entity.SeaPhantomEntity;
import net.mcreator.thalassophobia.init.ThalassophobiaModEntities;
import net.mcreator.thalassophobia.procedures.ArchelonEntityDiesProcedure;
import net.mcreator.thalassophobia.procedures.ArchelonOnEntityTickUpdateProcedure;
import net.mcreator.thalassophobia.procedures.ArchelonOnInitialEntitySpawnProcedure;
import net.mcreator.thalassophobia.procedures.ArchelonPlayerCollidesWithThisEntityProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArchelonEntity
extends PathfinderMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(ArchelonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(ArchelonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(ArchelonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public ArchelonEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ArchelonEntity>)((EntityType)ThalassophobiaModEntities.ARCHELON.get()), world);
    }

    public ArchelonEntity(EntityType<ArchelonEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (ArchelonEntity.this.m_20069_()) {
                    ArchelonEntity.this.m_20256_(ArchelonEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !ArchelonEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - ArchelonEntity.this.m_20185_();
                    double dy = this.f_24976_ - ArchelonEntity.this.m_20186_();
                    double dz = this.f_24977_ - ArchelonEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * ArchelonEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    ArchelonEntity.this.m_146922_(this.m_24991_(ArchelonEntity.this.m_146908_(), f, 10.0f));
                    ArchelonEntity.this.f_20883_ = ArchelonEntity.this.m_146908_();
                    ArchelonEntity.this.f_20885_ = ArchelonEntity.this.m_146908_();
                    if (ArchelonEntity.this.m_20069_()) {
                        ArchelonEntity.this.m_7910_((float)ArchelonEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        ArchelonEntity.this.m_146926_(this.m_24991_(ArchelonEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(ArchelonEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        ArchelonEntity.this.m_21564_(f3 * f1);
                        ArchelonEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        ArchelonEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    ArchelonEntity.this.m_7910_(0.0f);
                    ArchelonEntity.this.m_21567_(0.0f);
                    ArchelonEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"archelon2");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(this, 2.0, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, CnidariaEntity.class, false, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SeaPhantomEntity.class, false, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("thalassophobia:entity.archelon.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("thalassophobia:entity.archelon.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("thalassophobia:entity.archelon.hurt"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        ArchelonEntityDiesProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        ArchelonOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        ArchelonOnEntityTickUpdateProcedure.execute((Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.5f);
    }

    public void m_6123_(Player sourceentity) {
        super.m_6123_(sourceentity);
        ArchelonPlayerCollidesWithThisEntityProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this, (Entity)sourceentity);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ThalassophobiaModEntities.ARCHELON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.m_20072_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.archelon.swim"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.archelon.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.archelon.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

