/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.apiimpl.network.node.StorageMonitorNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class StorageMonitorBlockEntity
extends NetworkNodeBlockEntity<StorageMonitorNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, StorageMonitorBlockEntity> COMPARE = IComparable.createParameter(new ResourceLocation("refinedstorage", "storage_monitor_compare"));
    public static final BlockEntitySynchronizationParameter<Integer, StorageMonitorBlockEntity> TYPE = IType.createParameter(new ResourceLocation("refinedstorage", "storage_monitor_type"));
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUIDSTACK = "FluidStack";
    private static final String NBT_STACK = "Stack";
    private static final String NBT_AMOUNT = "Amount";
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(COMPARE).addWatchedParameter(TYPE).build();
    private int type;
    private int amount;
    @Nullable
    private ItemStack itemStack = ItemStack.f_41583_;
    @Nullable
    private FluidStack fluidStack = FluidStack.EMPTY;

    public StorageMonitorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RSBlockEntities.STORAGE_MONITOR.get(), pos, state, SPEC, StorageMonitorNetworkNode.class);
    }

    @Override
    public StorageMonitorNetworkNode createNode(Level level, BlockPos pos) {
        return new StorageMonitorNetworkNode(level, pos);
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        FluidStack fluid;
        super.writeUpdate(tag);
        ItemStack stack = ((StorageMonitorNetworkNode)this.getNode()).getItemFilters().getStackInSlot(0);
        if (!stack.m_41619_()) {
            tag.m_128365_(NBT_STACK, (Tag)stack.m_41739_(new CompoundTag()));
        }
        if (!(fluid = ((StorageMonitorNetworkNode)this.getNode()).getFluidFilters().getFluid(0)).isEmpty()) {
            tag.m_128365_(NBT_FLUIDSTACK, (Tag)fluid.writeToNBT(new CompoundTag()));
        }
        tag.m_128405_(NBT_TYPE, ((StorageMonitorNetworkNode)this.getNode()).getType());
        tag.m_128405_(NBT_AMOUNT, ((StorageMonitorNetworkNode)this.getNode()).getAmount());
        return tag;
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        this.fluidStack = tag.m_128441_(NBT_FLUIDSTACK) ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(NBT_FLUIDSTACK)) : FluidStack.EMPTY;
        this.itemStack = tag.m_128441_(NBT_STACK) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_STACK)) : ItemStack.f_41583_;
        this.type = tag.m_128441_(NBT_TYPE) ? tag.m_128451_(NBT_TYPE) : 0;
        this.amount = tag.m_128451_(NBT_AMOUNT);
    }

    public int getAmount() {
        return this.amount;
    }

    public int getStackType() {
        return this.type;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nullable
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

