/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class WarpForceTest {
    private static final String TEMPLATE = "botania:item/lens/force_warp_relay_interaction";
    private static final BlockPos SPREADER_POS = new BlockPos(1, 2, 1);
    private static final BlockPos SPREADER_TARGET_POS = new BlockPos(6, 2, 1);
    private static final BlockPos BUTTON_POS = new BlockPos(1, 2, 3);
    private static final BlockPos RELAY_POS = new BlockPos(3, 2, 1);
    private static final BlockPos BOUND_POS = new BlockPos(3, 2, 3);

    @GameTest(template="botania:item/lens/force_warp_relay_interaction", timeoutTicks=50)
    public void testWarpForceLens(GameTestHelper helper) {
        WarpForceTest.setUpLensesAndBindings(helper, BotaniaItems.lensWarp, BotaniaItems.lensPiston);
        helper.m_177425_().m_177546_(1, () -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177275_(RELAY_POS, BotaniaBlocks.pistonRelay::equals, () -> "Force relay moved");
            helper.m_177357_(BOUND_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Bound block did not move");
            helper.m_177275_(BOUND_POS.m_122029_(), Blocks.f_50387_::equals, () -> "Bound block did not move to expected position");
            TestingUtil.assertEquals(TestingUtil.getBoundForceRelayTarget(helper, RELAY_POS), helper.m_177449_(BOUND_POS), () -> "Relay binding has changed");
        }).m_177562_(() -> helper.m_177245_(BOUND_POS, Blocks.f_50281_)).m_177562_(() -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177357_(RELAY_POS, blockState -> blockState.m_60713_(BotaniaBlocks.pistonRelay), () -> "Force relay moved after second burst");
            helper.m_177357_(BOUND_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Bound block did not move");
            helper.m_177275_(BOUND_POS.m_122029_(), Blocks.f_50281_::equals, () -> "New block did not move to expected position after second burst");
            helper.m_177275_(BOUND_POS.m_122030_(2), Blocks.f_50387_::equals, () -> "Original block did not move to expected position after second burst");
            TestingUtil.assertEquals(TestingUtil.getBoundForceRelayTarget(helper, RELAY_POS), helper.m_177449_(BOUND_POS), () -> "Relay binding has changed after second burst");
        }).m_177543_();
    }

    @GameTest(template="botania:item/lens/force_warp_relay_interaction", timeoutTicks=50)
    public void testForceWarpLens(GameTestHelper helper) {
        WarpForceTest.setUpLensesAndBindings(helper, BotaniaItems.lensPiston, BotaniaItems.lensWarp);
        helper.m_177425_().m_177546_(1, () -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177357_(RELAY_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Force relay did not move");
            helper.m_177275_(RELAY_POS.m_122029_(), BotaniaBlocks.pistonRelay::equals, () -> "Force relay did not move to expected position");
            helper.m_177357_(BOUND_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Bound block did not move");
            helper.m_177275_(BOUND_POS.m_122029_(), Blocks.f_50387_::equals, () -> "Bound block did not move to expected position");
            TestingUtil.assertEquals(TestingUtil.getBoundForceRelayTarget(helper, RELAY_POS.m_122029_()), helper.m_177449_(BOUND_POS.m_122029_()), () -> "Relay binding was not updated");
        }).m_177562_(() -> helper.m_177245_(BOUND_POS, Blocks.f_50281_)).m_177562_(() -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177275_(BOUND_POS, Blocks.f_50281_::equals, () -> "New block at original bound position moved");
            helper.m_177357_(RELAY_POS.m_122029_(), BlockBehaviour.BlockStateBase::m_60795_, () -> "Force relay did not move after second burst");
            helper.m_177275_(RELAY_POS.m_122030_(2), BotaniaBlocks.pistonRelay::equals, () -> "Force relay did not move to expected position after second burst");
            helper.m_177357_(BOUND_POS.m_122029_(), BlockBehaviour.BlockStateBase::m_60795_, () -> "Bound block did not move a second time");
            helper.m_177275_(BOUND_POS.m_122030_(2), Blocks.f_50387_::equals, () -> "Bound block did not move to expected position after second burst");
            TestingUtil.assertEquals(TestingUtil.getBoundForceRelayTarget(helper, RELAY_POS.m_122030_(2)), helper.m_177449_(BOUND_POS.m_122030_(2)), () -> "Relay binding was not updated after second burst");
        }).m_177543_();
    }

    private static void setUpLensesAndBindings(GameTestHelper helper, Item firstLensType, Item secondLensType) {
        TestingUtil.setUpSpreaderAndCompositeLens(helper, firstLensType, secondLensType, SPREADER_POS, SPREADER_TARGET_POS);
        TestingUtil.bindForceRelayTarget(helper, RELAY_POS, BOUND_POS);
    }
}

