/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.OpenCrateBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;

public class OpenCrateBlock
extends BotaniaBlock
implements EntityBlock {
    protected OpenCrateBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!newState.m_60713_(state.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (world.m_276867_(pos) && rand.m_188500_() < 0.2) {
            OpenCrateBlock.redstoneParticlesOnFullBlock(world, pos, rand);
        }
    }

    public static void redstoneParticlesOnFullBlock(Level world, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double dx = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double dy = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.m_188501_();
            double dz = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + dz, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new OpenCrateBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return OpenCrateBlock.createTickerHelper(type, BotaniaBlockEntities.OPEN_CRATE, OpenCrateBlockEntity::serverTick);
        }
        return null;
    }
}

