/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.ManaWidget;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaInfusionEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png");
    private static final EmiStack POOL;
    private final int mana;

    public ManaInfusionEmiRecipe(ManaInfusionRecipe recipe) {
        super(BotaniaEmiPlugin.MANA_INFUSION, recipe);
        this.input = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
        if (recipe.getRecipeCatalyst() != null) {
            this.catalysts = List.of(EmiIngredient.of(recipe.getRecipeCatalyst().getDisplayed().stream().map(s -> EmiStack.of((ItemLike)s.m_60734_())).toList()));
        }
        this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)));
        this.mana = recipe.getManaToConsume();
    }

    public int getDisplayHeight() {
        return 65;
    }

    public int getDisplayWidth() {
        return 116;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 28, 0, 65, 44, 0, 0));
        widgets.add((Widget)new ManaWidget(7, 50, this.mana, 100000));
        widgets.addSlot((EmiIngredient)this.input.get(0), 21, 13).drawBack(false);
        widgets.addSlot((EmiIngredient)POOL, 50, 13).catalyst(true).drawBack(false);
        if (this.catalysts.size() > 0) {
            widgets.addSlot((EmiIngredient)this.catalysts.get(0), 0, 13).catalyst(true).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 79, 13).drawBack(false).recipeContext((EmiRecipe)this);
    }

    static {
        ItemStack stack = new ItemStack((ItemLike)BotaniaBlocks.manaPool);
        ItemNBTHelper.setBoolean(stack, "RenderFull", true);
        POOL = EmiStack.of((ItemStack)stack);
    }
}

