/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.common;

import com.alrex.parcool.common.action.impl.HideInBlock;
import com.alrex.parcool.common.capability.Parkourability;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
extends CapabilityProvider<Entity> {
    protected EntityMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Inject(method={"getEyeHeight()F"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetEyeHeight(CallbackInfoReturnable<Float> cir) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof Player)) {
            return;
        }
        Player player = (Player)entityMixin;
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        HideInBlock ability = parkourability.get(HideInBlock.class);
        Tuple<BlockPos, BlockPos> area = ability.getHidingArea();
        if (ability.isDoing() && area != null) {
            float eyeHeight;
            int areaHeight = ((BlockPos)area.m_14419_()).m_123342_() - ((BlockPos)area.m_14418_()).m_123342_() + 1;
            if ((float)areaHeight < (eyeHeight = player.m_6972_((Pose)Pose.STANDING).f_20378_ * 0.85f)) {
                cir.setReturnValue((Object)Float.valueOf(eyeHeight));
            } else {
                cir.setReturnValue((Object)Float.valueOf((float)areaHeight + 0.2f));
            }
            return;
        }
    }

    @Inject(method={"isInWall"}, at={@At(value="HEAD")}, cancellable=true)
    public void onIsInWall(CallbackInfoReturnable<Boolean> cir) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof Player)) {
            return;
        }
        Player player = (Player)entityMixin;
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        HideInBlock hideInBlock = parkourability.get(HideInBlock.class);
        if (hideInBlock.isDoing() || hideInBlock.getNotDoingTick() < 2) {
            cir.setReturnValue((Object)false);
        }
    }
}

